/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObject;
import org.verapdf.external.ICCProfile;
import org.verapdf.gf.model.impl.cos.GFCosObject;
import org.verapdf.gf.model.impl.external.GFICCOutputProfile;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosObject;
import org.verapdf.model.external.ICCOutputProfile;
import org.verapdf.model.pdlayer.PDOutputIntent;
import org.verapdf.pd.PDObject;

public class GFPDOutputIntent
extends GFPDObject
implements PDOutputIntent {
    public static final String OUTPUT_INTENT_TYPE = "PDOutputIntent";
    public static final String DEST_PROFILE = "destProfile";
    public static final String DEST_OUTPUT_PROFILE_REF = "DestOutputProfileRef";

    public GFPDOutputIntent(org.verapdf.pd.PDOutputIntent simplePDObject) {
        super((PDObject)simplePDObject, OUTPUT_INTENT_TYPE);
    }

    public String getdestOutputProfileIndirect() {
        COSObject obj = this.simplePDObject.getKey(ASAtom.DEST_OUTPUT_PROFILE);
        if (!obj.empty() && obj.isIndirect().booleanValue()) {
            COSKey key = obj.getKey();
            return String.valueOf(key.getNumber() + " " + key.getGeneration());
        }
        return null;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "destProfile": {
                return this.getDestProfile();
            }
            case "DestOutputProfileRef": {
                return this.getDestOutputProfileRef();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<ICCOutputProfile> getDestProfile() {
        ICCProfile iccProfile = ((org.verapdf.pd.PDOutputIntent)this.simplePDObject).getDestOutputProfile();
        if (iccProfile != null) {
            ArrayList<GFICCOutputProfile> profile = new ArrayList<GFICCOutputProfile>(1);
            String subtype = ((org.verapdf.pd.PDOutputIntent)this.simplePDObject).getSubtype();
            profile.add(new GFICCOutputProfile(iccProfile, subtype));
            return Collections.unmodifiableList(profile);
        }
        return Collections.emptyList();
    }

    private List<CosObject> getDestOutputProfileRef() {
        CosObject value;
        COSObject ref = ((org.verapdf.pd.PDOutputIntent)this.simplePDObject).getCOSDestOutputProfileRef();
        CosObject cosObject = value = ref == null ? null : GFCosObject.getFromValue(ref.get());
        if (value != null) {
            ArrayList<CosObject> list = new ArrayList<CosObject>(1);
            list.add(value);
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

