/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.colors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosUnicodeName;
import org.verapdf.gf.model.impl.pd.colors.GFPDColorSpace;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.colors.PDSeparation;

public class GFPDSeparation
extends GFPDColorSpace
implements org.verapdf.model.pdlayer.PDSeparation {
    public static final String SEPARATION_TYPE = "PDSeparation";
    public static final String ALTERNATE = "alternate";
    public static final String COLORANT_NAME = "colorantName";

    public GFPDSeparation(PDSeparation simplePDObject) {
        super((PDColorSpace)simplePDObject, SEPARATION_TYPE);
        String name = simplePDObject.getColorantName().getString();
        if (StaticContainers.separations.containsKey(name)) {
            StaticContainers.separations.get(name).add(this);
        } else {
            ArrayList<GFPDSeparation> separationList = new ArrayList<GFPDSeparation>();
            separationList.add(this);
            StaticContainers.separations.put(name, separationList);
        }
    }

    public Boolean getareTintAndAlternateConsistent() {
        String name = ((PDSeparation)this.simplePDObject).getColorantName().getString();
        if (StaticContainers.inconsistentSeparations.contains(name)) {
            return Boolean.FALSE;
        }
        if (StaticContainers.separations.get(name).size() > 1) {
            for (GFPDSeparation gfPDSeparation : StaticContainers.separations.get(name)) {
                if (((java.lang.Object)((java.lang.Object)gfPDSeparation)).equals((java.lang.Object)this)) continue;
                COSObject alternateSpaceToCompare = ((PDSeparation)gfPDSeparation.simplePDObject).getAlternate().getObject();
                COSObject tintTransformToCompare = ((PDSeparation)gfPDSeparation.simplePDObject).getTintTransform();
                COSObject alternateSpaceCurrent = ((PDSeparation)this.simplePDObject).getAlternate().getObject();
                COSObject tintTransformCurrent = ((PDSeparation)this.simplePDObject).getTintTransform();
                if (alternateSpaceToCompare.equals((java.lang.Object)alternateSpaceCurrent) && tintTransformToCompare.equals((java.lang.Object)tintTransformCurrent)) continue;
                StaticContainers.inconsistentSeparations.add(name);
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "alternate": {
                return this.getAlternate();
            }
            case "colorantName": {
                return this.getColorantName();
            }
        }
        return super.getLinkedObjects(link);
    }

    public List<org.verapdf.model.pdlayer.PDColorSpace> getAlternate() {
        PDColorSpace space = ((PDSeparation)this.simplePDObject).getAlternate();
        org.verapdf.model.pdlayer.PDColorSpace currentSpace = ColorSpaceFactory.getColorSpace(space);
        if (currentSpace != null) {
            ArrayList<org.verapdf.model.pdlayer.PDColorSpace> colorSpace = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(1);
            colorSpace.add(currentSpace);
            return Collections.unmodifiableList(colorSpace);
        }
        return Collections.emptyList();
    }

    private List<CosUnicodeName> getColorantName() {
        COSObject name = ((PDSeparation)this.simplePDObject).getColorantName();
        if (name.getType() == COSObjType.COS_NAME) {
            ArrayList<GFCosUnicodeName> list = new ArrayList<GFCosUnicodeName>(1);
            list.add(new GFCosUnicodeName((COSName)name.getDirectBase()));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

