/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.impl.VeraPDFMeta;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.ReleaseDetails;
import org.verapdf.component.ComponentDetails;
import org.verapdf.component.Components;
import org.verapdf.core.EncryptedPdfException;
import org.verapdf.core.ModelParsingException;
import org.verapdf.exceptions.InvalidPasswordException;
import org.verapdf.features.AbstractFeaturesExtractor;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.features.gf.GFFeatureParser;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosDocument;
import org.verapdf.metadata.fixer.entity.PDFDocument;
import org.verapdf.metadata.fixer.gf.impl.model.PDFDocumentImpl;
import org.verapdf.pd.PDDocument;
import org.verapdf.pd.PDMetadata;
import org.verapdf.pdfa.Foundries;
import org.verapdf.pdfa.PDFAParser;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class GFModelParser
implements PDFAParser {
    private static final ReleaseDetails greenfieldDetails = ReleaseDetails.addDetailsFromResource((String)"org/verapdf/release/validation-model.properties");
    private static final URI id = URI.create("http://pdfa.verapdf.org/parser#verapdf");
    private static final ComponentDetails details = Components.veraDetails((URI)id, (String)"VeraPDF Parser", (String)greenfieldDetails.getVersion(), (String)"veraPDF greenfield PDF parser.");
    private static final Logger logger = Logger.getLogger(GFModelParser.class.getCanonicalName());
    private PDDocument document;
    private final PDFAFlavour flavour;

    private GFModelParser(InputStream docStream, PDFAFlavour flavour) throws IOException {
        try {
            this.document = new PDDocument(docStream);
            this.flavour = flavour == PDFAFlavour.NO_FLAVOUR ? GFModelParser.obtainFlavour(this.document) : flavour;
            GFModelParser.initializeStaticContainers(this.document, this.flavour);
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    private GFModelParser(File pdfFile, PDFAFlavour flavour) throws IOException {
        try {
            this.document = new PDDocument(pdfFile.getAbsolutePath());
            this.flavour = flavour == PDFAFlavour.NO_FLAVOUR ? GFModelParser.obtainFlavour(this.document) : flavour;
            GFModelParser.initializeStaticContainers(this.document, this.flavour);
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    public static GFModelParser createModelWithFlavour(InputStream toLoad, PDFAFlavour flavour) throws ModelParsingException, EncryptedPdfException {
        try {
            return new GFModelParser(toLoad, flavour);
        }
        catch (InvalidPasswordException excep) {
            throw new EncryptedPdfException("The PDF stream appears to be encrypted.", (Throwable)excep);
        }
        catch (IOException e) {
            throw new ModelParsingException("Couldn't parse stream", (Throwable)e);
        }
    }

    public static GFModelParser createModelWithFlavour(File pdfFile, PDFAFlavour flavour) throws ModelParsingException, EncryptedPdfException {
        try {
            return new GFModelParser(pdfFile, flavour);
        }
        catch (InvalidPasswordException excep) {
            throw new EncryptedPdfException("The PDF stream appears to be encrypted.", (Throwable)excep);
        }
        catch (IOException e) {
            throw new ModelParsingException("Couldn't parse stream", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PDFAFlavour obtainFlavour(PDDocument document) {
        PDMetadata metadata = null;
        PDFAFlavour defaultFlavour = Foundries.defaultInstance().defaultFlavour();
        try {
            if (document == null) return defaultFlavour;
            if (document.getCatalog() == null) {
                return defaultFlavour;
            }
            metadata = document.getCatalog().getMetadata();
            if (metadata == null) {
                return defaultFlavour;
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Problem parsing metadata from document catalog.", e);
            return defaultFlavour;
        }
        try (InputStream is = metadata.getStream();){
            PDFAFlavour pdfaFlavour;
            VeraPDFMeta veraPDFMeta = VeraPDFMeta.parse((InputStream)is);
            Integer identificationPart = veraPDFMeta.getIdentificationPart();
            String identificationConformance = veraPDFMeta.getIdentificationConformance();
            PDFAFlavour pDFAFlavour = pdfaFlavour = PDFAFlavour.byFlavourId((String)(identificationPart + identificationConformance));
            return pDFAFlavour;
        }
        catch (XMPException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return defaultFlavour;
        }
        catch (IOException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return defaultFlavour;
        }
    }

    private static void initializeStaticContainers(PDDocument document, PDFAFlavour flavour) {
        StaticContainers.clearAllContainers();
        StaticContainers.setDocument(document);
        StaticContainers.setFlavour(flavour);
    }

    public PDDocument getPDDocument() {
        return this.document;
    }

    public org.verapdf.model.baselayer.Object getRoot() {
        return new GFCosDocument(this.document.getDocument());
    }

    public ComponentDetails getDetails() {
        return details;
    }

    public PDFAFlavour getFlavour() {
        return this.flavour;
    }

    public PDFDocument getPDFDocument() {
        return new PDFDocumentImpl(this.document);
    }

    public FeatureExtractionResult getFeatures(FeatureExtractorConfig config) {
        return GFFeatureParser.getFeaturesCollection((PDDocument)this.document, (FeatureExtractorConfig)config);
    }

    public FeatureExtractionResult getFeatures(FeatureExtractorConfig config, List<AbstractFeaturesExtractor> extractors) {
        return GFFeatureParser.getFeaturesCollection((PDDocument)this.document, extractors, (FeatureExtractorConfig)config);
    }

    public void close() {
        if (this.document != null) {
            this.document.close();
        }
    }
}

