/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.external;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.core.VeraPDFException;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.GFModelParser;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.external.GFExternal;
import org.verapdf.gf.model.impl.pd.colors.GFPDSeparation;
import org.verapdf.gf.model.impl.pd.util.TaggedPDFRoleMapHelper;
import org.verapdf.model.external.EmbeddedFile;
import org.verapdf.model.pdlayer.PDColorSpace;
import org.verapdf.pd.PDDocument;
import org.verapdf.pdfa.PDFAParser;
import org.verapdf.pdfa.PDFAValidator;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.validation.validators.ValidatorFactory;

public class GFEmbeddedFile
extends GFExternal
implements EmbeddedFile {
    private static final Logger LOGGER = Logger.getLogger(GFEmbeddedFile.class.getCanonicalName());
    public static final String EMBEDDED_FILE_TYPE = "EmbeddedFile";
    private final COSStream stream;
    private PDDocument document;
    private PDFAFlavour flavour;
    public TaggedPDFRoleMapHelper roleMapHelper;
    public Map<String, List<GFPDSeparation>> separations;
    public List<String> inconsistentSeparations;
    public Map<String, PDColorSpace> cachedColorSpaces;
    public static Set<COSKey> fileSpecificationKeys;

    public GFEmbeddedFile(COSDictionary dictionary) {
        super(EMBEDDED_FILE_TYPE);
        COSObject baseStream = dictionary.getKey(ASAtom.F);
        this.stream = baseStream != null && baseStream.getType() == COSObjType.COS_STREAM ? (COSStream)baseStream.getDirectBase() : null;
    }

    public String getSubtype() {
        if (this.stream != null) {
            ASAtom s = this.stream.getNameKey(ASAtom.SUBTYPE);
            return s == null ? null : s.getValue();
        }
        return null;
    }

    public Boolean getisValidPDFA12() {
        if (this.stream == null) {
            return Boolean.TRUE;
        }
        boolean retVal = false;
        this.saveStaticContainersState();
        try (ASInputStream unfilteredStream = this.stream.getData(COSStream.FilterFlags.DECODE);){
            retVal = GFEmbeddedFile.isValidPdfaStream((InputStream)unfilteredStream, PDFAFlavour.PDFA_1_B);
            if (!retVal) {
                unfilteredStream.reset();
                retVal = GFEmbeddedFile.isValidPdfaStream((InputStream)unfilteredStream, PDFAFlavour.PDFA_2_B);
            }
        }
        catch (IOException | VeraPDFException e) {
            LOGGER.log(Level.FINE, "Exception during validation of embedded file", e);
        }
        this.restoreSavedSCState();
        return retVal;
    }

    private static boolean isValidPdfaStream(InputStream toValidate, PDFAFlavour flavour) throws VeraPDFException {
        try (GFModelParser parser = GFModelParser.createModelWithFlavour(toValidate, flavour);){
            PDFAValidator validator1b = ValidatorFactory.createValidator((PDFAFlavour)flavour, (boolean)false, (int)1);
            ValidationResult result1b = validator1b.validate((PDFAParser)parser);
            parser.close();
            boolean bl = result1b.isCompliant();
            return bl;
        }
    }

    private void saveStaticContainersState() {
        this.document = StaticContainers.getDocument();
        this.flavour = StaticContainers.getFlavour();
        this.separations = StaticContainers.separations;
        this.inconsistentSeparations = StaticContainers.inconsistentSeparations;
        this.cachedColorSpaces = StaticContainers.cachedColorSpaces;
        this.roleMapHelper = StaticContainers.roleMapHelper;
        fileSpecificationKeys = StaticContainers.fileSpecificationKeys;
    }

    private void restoreSavedSCState() {
        StaticContainers.setDocument(this.document);
        StaticContainers.setFlavour(this.flavour);
        StaticContainers.separations = this.separations;
        StaticContainers.inconsistentSeparations = this.inconsistentSeparations;
        StaticContainers.cachedColorSpaces = this.cachedColorSpaces;
        StaticContainers.roleMapHelper = this.roleMapHelper;
        StaticContainers.fileSpecificationKeys = fileSpecificationKeys;
    }
}

