/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.verapdf.wcag.algorithms.entities.SemanticNode;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TextChunkUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection.ListLabelsDetectionAlgorithm;

public class SemanticTextNode
extends SemanticNode {
    protected final List<TextLine> lines;
    private Double fontWeight;
    private Double fontSize;
    private double[] textColor;
    private Double italicAngle;
    private String fontName;

    public SemanticTextNode(SemanticTextNode textNode) {
        super(textNode.getBoundingBox(), textNode.getInitialSemanticType(), textNode.getSemanticType());
        this.lines = new ArrayList<TextLine>(textNode.getLines());
        this.fontWeight = textNode.fontWeight;
        this.fontSize = textNode.fontSize;
        this.textColor = textNode.textColor;
        this.italicAngle = textNode.italicAngle;
        this.fontName = textNode.fontName;
    }

    public SemanticTextNode() {
        this.lines = new ArrayList<TextLine>();
    }

    public SemanticTextNode(SemanticType initialSemanticType) {
        super(initialSemanticType);
        this.lines = new ArrayList<TextLine>();
    }

    public SemanticTextNode(BoundingBox bbox) {
        super(bbox);
        this.lines = new ArrayList<TextLine>();
    }

    public SemanticTextNode(BoundingBox bbox, SemanticType initialSemanticType) {
        super(bbox, initialSemanticType);
        this.lines = new ArrayList<TextLine>();
    }

    public SemanticTextNode(BoundingBox bbox, List<TextLine> lines) {
        super(bbox);
        this.lines = new ArrayList<TextLine>(lines);
    }

    public SemanticTextNode(TextChunk textChunk) {
        this.lines = new ArrayList<TextLine>();
        this.add(new TextLine(textChunk));
    }

    public SemanticTextNode(BoundingBox bbox, List<TextLine> lines, SemanticType initialSemanticType) {
        super(bbox, initialSemanticType);
        this.lines = new ArrayList<TextLine>(lines);
    }

    public SemanticTextNode(TextChunk textChunk, SemanticType initialSemanticType) {
        this(initialSemanticType);
        this.add(new TextLine(textChunk));
    }

    public void add(TextLine textLine) {
        this.lines.add(textLine);
        this.getBoundingBox().union(textLine.getBoundingBox());
        this.updateVariables();
    }

    public void addAll(List<TextLine> text) {
        if (text == null || text.size() == 0) {
            return;
        }
        this.lines.addAll(text);
        for (TextLine textLine : text) {
            this.getBoundingBox().union(textLine.getBoundingBox());
        }
        this.updateVariables();
    }

    private void updateVariables() {
        this.fontSize = null;
        this.fontWeight = null;
        this.textColor = null;
        this.italicAngle = null;
        this.fontName = null;
    }

    public List<TextLine> getLines() {
        return this.lines;
    }

    public int getLinesNumber() {
        return this.lines.size();
    }

    public TextLine getFirstLine() {
        if (!this.lines.isEmpty()) {
            return this.lines.get(0);
        }
        return null;
    }

    public void setFirstLine(TextLine firstLine) {
        if (!this.lines.isEmpty()) {
            this.lines.set(0, firstLine);
        } else {
            this.lines.add(firstLine);
        }
        this.updateVariables();
    }

    public void setLastLine(TextLine lastLine) {
        if (!this.lines.isEmpty()) {
            this.lines.set(this.lines.size() - 1, lastLine);
        } else {
            this.lines.add(lastLine);
        }
        this.updateVariables();
    }

    public TextLine getSecondLine() {
        if (this.lines.size() > 1) {
            return this.lines.get(1);
        }
        return null;
    }

    public TextLine getPenultLine() {
        if (this.lines.size() > 1) {
            return this.lines.get(this.lines.size() - 2);
        }
        return null;
    }

    public TextLine getLastLine() {
        if (!this.lines.isEmpty()) {
            return this.lines.get(this.lines.size() - 1);
        }
        return null;
    }

    public double getFirstBaseline() {
        if (!this.isEmpty()) {
            return this.lines.get(0).getBaseLine();
        }
        return 0.0;
    }

    public double getLastBaseline() {
        if (!this.isEmpty()) {
            return this.lines.get(this.lines.size() - 1).getBaseLine();
        }
        return 0.0;
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    public double getFontWeight() {
        if (this.fontWeight == null) {
            this.fontWeight = this.calculateFontWeight();
        }
        return this.fontWeight;
    }

    private double calculateFontWeight() {
        HashMap<Double, Double> fontWeightMap = new HashMap<Double, Double>();
        for (TextLine line : this.lines) {
            for (TextChunk chunk : line.getTextChunks()) {
                if (TextChunkUtils.isWhiteSpaceChunk(chunk)) continue;
                Double weightLength = (Double)fontWeightMap.get(chunk.getFontWeight());
                fontWeightMap.put(chunk.getFontWeight(), (weightLength == null ? 0.0 : weightLength) + chunk.getBoundingBox().getWidth());
            }
        }
        if (!fontWeightMap.isEmpty()) {
            return (Double)fontWeightMap.entrySet().stream().max(Comparator.comparingDouble(Map.Entry::getValue)).get().getKey();
        }
        return 0.0;
    }

    public boolean hasFullLines() {
        if (!this.isEmpty()) {
            return this.getFirstLine().isFullLine() && this.getLastLine().isFullLine();
        }
        return true;
    }

    public double getFontSize() {
        if (this.fontSize == null) {
            this.fontSize = this.calculateFontSize();
        }
        return this.fontSize;
    }

    private double calculateFontSize() {
        HashMap<Double, Double> fontSizeMap = new HashMap<Double, Double>();
        for (TextLine line : this.lines) {
            for (TextChunk chunk : line.getTextChunks()) {
                if (TextChunkUtils.isWhiteSpaceChunk(chunk)) continue;
                Double sizeLength = (Double)fontSizeMap.get(chunk.getFontSize());
                fontSizeMap.put(chunk.getFontSize(), (sizeLength == null ? 0.0 : sizeLength) + chunk.getBoundingBox().getWidth());
            }
        }
        if (!fontSizeMap.isEmpty()) {
            return (Double)fontSizeMap.entrySet().stream().max(Comparator.comparingDouble(Map.Entry::getValue)).get().getKey();
        }
        return 0.0;
    }

    public double getItalicAngle() {
        if (this.italicAngle == null) {
            this.italicAngle = this.calculateItalicAngle();
        }
        return this.italicAngle;
    }

    private double calculateItalicAngle() {
        HashMap<Double, Double> italicAngleMap = new HashMap<Double, Double>();
        for (TextLine line : this.lines) {
            for (TextChunk chunk : line.getTextChunks()) {
                if (TextChunkUtils.isWhiteSpaceChunk(chunk)) continue;
                Double sizeLength = (Double)italicAngleMap.get(chunk.getItalicAngle());
                italicAngleMap.put(chunk.getItalicAngle(), (sizeLength == null ? 0.0 : sizeLength) + chunk.getBoundingBox().getWidth());
            }
        }
        if (!italicAngleMap.isEmpty()) {
            return (Double)italicAngleMap.entrySet().stream().max(Comparator.comparingDouble(Map.Entry::getValue)).get().getKey();
        }
        return 0.0;
    }

    public double[] getTextColor() {
        if (this.textColor == null) {
            this.textColor = this.calculateTextColor();
        }
        return this.textColor;
    }

    private double[] calculateTextColor() {
        HashMap<double[], Double> textColorMap = new HashMap<double[], Double>();
        for (TextLine line : this.lines) {
            for (TextChunk chunk : line.getTextChunks()) {
                if (TextChunkUtils.isWhiteSpaceChunk(chunk)) continue;
                Double fontNameLength = (Double)textColorMap.get(chunk.getFontColor());
                textColorMap.put(chunk.getFontColor(), (fontNameLength == null ? 0.0 : fontNameLength) + chunk.getBoundingBox().getWidth());
            }
        }
        if (!textColorMap.isEmpty()) {
            return (double[])textColorMap.entrySet().stream().max(Comparator.comparingDouble(Map.Entry::getValue)).get().getKey();
        }
        return new double[]{0.0};
    }

    public String getFontName() {
        if (this.fontName == null) {
            this.fontName = this.calculateFontName();
        }
        return this.fontName;
    }

    private String calculateFontName() {
        HashMap<String, Double> fontNameMap = new HashMap<String, Double>();
        for (TextLine line : this.lines) {
            for (TextChunk chunk : line.getTextChunks()) {
                if (TextChunkUtils.isWhiteSpaceChunk(chunk)) continue;
                Double fontNameLength = (Double)fontNameMap.get(chunk.getFontName());
                fontNameMap.put(chunk.getFontName(), (fontNameLength == null ? 0.0 : fontNameLength) + chunk.getBoundingBox().getWidth());
            }
        }
        if (!fontNameMap.isEmpty()) {
            return (String)fontNameMap.entrySet().stream().max(Comparator.comparingDouble(Map.Entry::getValue)).get().getKey();
        }
        return "";
    }

    public boolean isSpaceNode() {
        for (TextLine line : this.lines) {
            for (TextChunk chunk : line.getTextChunks()) {
                if (TextChunkUtils.isWhiteSpaceChunk(chunk)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isStartsWithArabicNumber() {
        String value = this.getFirstLine().getValue().trim();
        return !value.isEmpty() && ListLabelsDetectionAlgorithm.getRegexStartLength(value, "\\d+") > 0;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof SemanticTextNode)) {
            return false;
        }
        SemanticTextNode that = (SemanticTextNode)o;
        return this.lines.equals(that.getLines());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.lines.size();
        for (TextLine textLine : this.lines) {
            result = 31 * result + textLine.hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        if (this.lines.size() == 0) {
            return "SemanticTextNode{}";
        }
        StringBuilder result = new StringBuilder("SemanticTextNode{");
        result.append(this.lines.get(0));
        for (int i = 1; i < this.lines.size(); ++i) {
            result.append(", ");
            result.append(this.lines.get(i));
        }
        result.append("}");
        return result.toString();
    }
}

