/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.content;

import java.util.Comparator;
import java.util.Objects;
import org.verapdf.wcag.algorithms.entities.content.InfoChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.Vertex;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;

public class LineChunk
extends InfoChunk {
    public static int BUTT_CAP_STYLE = 0;
    public static int ROUND_CAP_STYLE = 1;
    public static int PROJECTING_SQUARE_CAP_STYLE = 2;
    private final Vertex start;
    private final Vertex end;
    private final double width;

    public LineChunk(Integer pageNumber, double startX, double startY, double endX, double endY) {
        this(pageNumber, startX, startY, endX, endY, 1.0);
    }

    public LineChunk(Integer pageNumber, double startX, double startY, double endX, double endY, double width) {
        super(new BoundingBox(pageNumber, Math.min(startX, endX) - 0.5 * width, Math.min(startY, endY) - 0.5 * width, Math.max(startX, endX) + 0.5 * width, Math.max(startY, endY) + 0.5 * width));
        this.start = new Vertex(pageNumber, startX, startY, 0.5 * width);
        this.end = new Vertex(pageNumber, endX, endY, 0.5 * width);
        this.width = width;
    }

    public double getStartX() {
        return this.start.getX();
    }

    public double getStartY() {
        return this.start.getY();
    }

    public Vertex getStart() {
        return this.start;
    }

    public double getEndX() {
        return this.end.getX();
    }

    public double getEndY() {
        return this.end.getY();
    }

    public Vertex getEnd() {
        return this.end;
    }

    public boolean isHorizontalLine() {
        return NodeUtils.areCloseNumbers(this.start.getY(), this.end.getY());
    }

    public boolean isVerticalLine() {
        return NodeUtils.areCloseNumbers(this.start.getX(), this.end.getX());
    }

    public double getWidth() {
        return this.width;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.start.getX(), this.start.getY(), this.end.getX(), this.end.getY(), this.width);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        LineChunk that = (LineChunk)o;
        return Double.compare(that.start.getX(), this.start.getX()) == 0 && Double.compare(that.start.getY(), this.start.getY()) == 0 && Double.compare(that.end.getX(), this.end.getX()) == 0 && Double.compare(that.end.getY(), this.end.getY()) == 0 && Double.compare(that.width, this.width) == 0;
    }

    public String toString() {
        return "LineChunk{startX=" + this.start.getX() + ", startY=" + this.start.getY() + ", endX=" + this.end.getX() + ", endY=" + this.end.getY() + ", width=" + this.width + '}';
    }

    public static Vertex getIntersectionVertex(LineChunk horizontalLine, LineChunk verticalLine) {
        if (verticalLine.getCenterX() < horizontalLine.getBoundingBox().getLeftX() || verticalLine.getCenterX() > horizontalLine.getBoundingBox().getRightX()) {
            return null;
        }
        if (horizontalLine.getCenterY() < verticalLine.getBoundingBox().getBottomY() || horizontalLine.getCenterY() > verticalLine.getBoundingBox().getTopY()) {
            return null;
        }
        return new Vertex(verticalLine.getBoundingBox().getPageNumber(), verticalLine.getCenterX(), horizontalLine.getCenterY(), Math.max(0.5 * verticalLine.width, 0.5 * horizontalLine.width));
    }

    public static LineChunk createLineChunk(Integer pageNumber, double startX, double startY, double endX, double endY, double width, int cap) {
        if (cap == ROUND_CAP_STYLE || cap == PROJECTING_SQUARE_CAP_STYLE) {
            return new LineChunk(pageNumber, startX, startY, endX, endY, width);
        }
        double length = Math.sqrt(Math.pow(startX - endX, 2.0) + Math.pow(startY - endY, 2.0));
        if (width > length) {
            double centerX = 0.5 * (startX + endX);
            double centerY = 0.5 * (startY + endY);
            double deltaX = (centerY - startY) * width / length;
            double deltaY = (centerX - startX) * width / length;
            return LineChunk.createLineChunk(pageNumber, centerX + deltaX, centerY - deltaY, centerX - deltaX, centerY + deltaY, length, BUTT_CAP_STYLE);
        }
        double deltaX = (endX - startX) * 0.5 * width / length;
        double deltaY = (endY - startY) * 0.5 * width / length;
        return LineChunk.createLineChunk(pageNumber, startX + deltaX, startY + deltaY, endX - deltaX, endY - deltaY, width, PROJECTING_SQUARE_CAP_STYLE);
    }

    public static class VerticalLineComparator
    implements Comparator<LineChunk> {
        @Override
        public int compare(LineChunk line1, LineChunk line2) {
            int res = Double.compare(line1.getCenterX(), line2.getCenterX());
            if (res != 0) {
                return res;
            }
            return Double.compare(line2.getCenterY(), line1.getCenterY());
        }
    }

    public static class HorizontalLineComparator
    implements Comparator<LineChunk> {
        @Override
        public int compare(LineChunk line1, LineChunk line2) {
            int res = Double.compare(line2.getCenterY(), line1.getCenterY());
            if (res != 0) {
                return res;
            }
            return Double.compare(line1.getCenterX(), line2.getCenterX());
        }
    }
}

