/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.content;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.verapdf.wcag.algorithms.entities.IDocument;
import org.verapdf.wcag.algorithms.entities.content.IChunk;
import org.verapdf.wcag.algorithms.entities.content.LineChunk;

public class LinesCollection {
    private final Map<Integer, SortedSet<LineChunk>> horizontalLines = new HashMap<Integer, SortedSet<LineChunk>>();
    private final Map<Integer, SortedSet<LineChunk>> verticalLines = new HashMap<Integer, SortedSet<LineChunk>>();
    private final IDocument document;

    public LinesCollection(IDocument document) {
        this.document = document;
    }

    public SortedSet<LineChunk> getHorizontalLines(Integer pageNumber) {
        SortedSet<LineChunk> lines = this.horizontalLines.get(pageNumber);
        if (lines == null) {
            lines = this.parseHorizontalLines(pageNumber);
        }
        return lines;
    }

    private SortedSet<LineChunk> parseHorizontalLines(Integer pageNumber) {
        TreeSet<LineChunk> lines = new TreeSet<LineChunk>(new LineChunk.HorizontalLineComparator());
        for (IChunk chunk : this.document.getArtifacts(pageNumber)) {
            LineChunk lineChunk;
            if (!(chunk instanceof LineChunk) || !(lineChunk = (LineChunk)chunk).isHorizontalLine()) continue;
            lines.add(lineChunk);
        }
        this.horizontalLines.put(pageNumber, lines);
        return lines;
    }

    public SortedSet<LineChunk> getVerticalLines(Integer pageNumber) {
        SortedSet<LineChunk> lines = this.verticalLines.get(pageNumber);
        if (lines == null) {
            lines = this.parseVerticalLines(pageNumber);
        }
        return lines;
    }

    private SortedSet<LineChunk> parseVerticalLines(Integer pageNumber) {
        TreeSet<LineChunk> lines = new TreeSet<LineChunk>(new LineChunk.VerticalLineComparator());
        for (IChunk chunk : this.document.getArtifacts(pageNumber)) {
            LineChunk lineChunk;
            if (!(chunk instanceof LineChunk) || !(lineChunk = (LineChunk)chunk).isVerticalLine()) continue;
            lines.add(lineChunk);
        }
        this.verticalLines.put(pageNumber, lines);
        return lines;
    }
}

