/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.content;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.verapdf.wcag.algorithms.entities.content.TextInfoChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;

public class TextChunk
extends TextInfoChunk {
    private String value;
    private String fontName;
    private double fontWeight;
    private double italicAngle;
    private double[] fontColor;
    private String fontColorSpace;
    private double contrastRatio;
    private boolean hasSpecialStyle = false;
    private boolean isUnderlinedText = false;

    public TextChunk() {
    }

    public TextChunk(BoundingBox bbox, String value, double fontSize, double baseLine) {
        super(bbox, fontSize, baseLine);
        this.value = value;
    }

    public TextChunk(BoundingBox bbox, String value, String fontName, double fontSize, double fontWeight, double italicAngle, double baseLine, double[] fontColor, String fontColorSpace) {
        super(bbox, fontSize, baseLine);
        this.value = value;
        this.fontName = fontName;
        this.fontWeight = fontWeight;
        this.italicAngle = italicAngle;
        this.fontColor = (double[])fontColor.clone();
        this.fontColorSpace = fontColorSpace;
    }

    public TextChunk(TextChunk chunk) {
        this(chunk.getBoundingBox(), chunk.value, chunk.fontName, chunk.fontSize, chunk.fontWeight, chunk.italicAngle, chunk.baseLine, chunk.fontColor, chunk.fontColorSpace);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public double getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(double fontWeight) {
        this.fontWeight = fontWeight;
    }

    public double getItalicAngle() {
        return this.italicAngle;
    }

    public void setItalicAngle(double italicAngle) {
        this.italicAngle = italicAngle;
    }

    public double[] getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(double[] fontColor) {
        this.fontColor = fontColor;
    }

    public double getContrastRatio() {
        return this.contrastRatio;
    }

    public void setContrastRatio(double contrastRatio) {
        this.contrastRatio = contrastRatio;
    }

    public boolean getHasSpecialStyle() {
        return this.hasSpecialStyle;
    }

    public void setHasSpecialStyle() {
        this.hasSpecialStyle = true;
    }

    public boolean getIsUnderlinedText() {
        return this.isUnderlinedText;
    }

    public void setIsUnderlinedText() {
        this.isUnderlinedText = true;
    }

    public String getFontColorSpace() {
        return this.fontColorSpace;
    }

    public void setFontColorSpace(String fontColorSpace) {
        this.fontColorSpace = fontColorSpace;
    }

    public void addAll(List<TextChunk> otherChunks) {
        StringBuilder text = new StringBuilder(this.value);
        for (TextChunk chunk : otherChunks) {
            text.append(chunk.getValue());
            super.add(chunk);
        }
        this.value = text.toString();
    }

    public void add(TextChunk chunk) {
        this.value = this.value + chunk.getValue();
        super.add(chunk);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TextChunk that = (TextChunk)o;
        return Double.compare(that.fontWeight, this.fontWeight) == 0 && Double.compare(that.italicAngle, this.italicAngle) == 0 && Objects.equals(this.value, that.value) && Objects.equals(this.fontName, that.fontName) && Objects.equals(this.fontColorSpace, that.fontColorSpace) && Arrays.equals(this.fontColor, that.fontColor);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.fontWeight, this.italicAngle);
        return result;
    }

    public String toString() {
        return "TextChunk{text='" + this.value + '\'' + ", fontName='" + this.fontName + '\'' + ", fontSize=" + this.fontSize + ", fontWeight=" + this.fontWeight + ", italicAngle=" + this.italicAngle + ", baseLine=" + this.baseLine + ", fontColor=" + Arrays.toString(this.fontColor) + ", fontColorSpace='" + this.fontColorSpace + '\'' + '}';
    }
}

