/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.content;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextInfoChunk;

public class TextLine
extends TextInfoChunk {
    private final List<TextChunk> textChunks = new ArrayList<TextChunk>();
    private boolean fullLine = true;

    public TextLine() {
    }

    public TextLine(TextChunk chunk) {
        super(chunk.getBoundingBox(), chunk.getFontSize(), chunk.getBaseLine());
        this.textChunks.add(chunk);
    }

    public TextLine(TextLine line) {
        super(line.getBoundingBox(), line.getFontSize(), line.getBaseLine());
        this.textChunks.addAll(line.getTextChunks());
    }

    public List<TextChunk> getTextChunks() {
        return this.textChunks;
    }

    public TextChunk getFirstTextChunk() {
        if (this.textChunks.isEmpty()) {
            return null;
        }
        return this.textChunks.get(0);
    }

    public TextChunk getLastTextChunk() {
        if (this.textChunks.isEmpty()) {
            return null;
        }
        return this.textChunks.get(this.textChunks.size() - 1);
    }

    public void add(TextChunk chunk) {
        this.textChunks.add(chunk);
        super.add(chunk);
    }

    public void add(TextLine line) {
        this.textChunks.addAll(line.getTextChunks());
        super.add(line);
    }

    public String getValue() {
        if (this.textChunks.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder(this.textChunks.get(0).getValue());
        for (int i = 1; i < this.textChunks.size(); ++i) {
            result.append(this.textChunks.get(i).getValue());
        }
        return result.toString();
    }

    public void setNotFullLine() {
        this.fullLine = false;
    }

    public boolean isFullLine() {
        return this.fullLine;
    }

    public String toString() {
        if (this.textChunks.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder(this.textChunks.get(0).getValue());
        for (int i = 1; i < this.textChunks.size(); ++i) {
            result.append(' ').append(this.textChunks.get(i).getValue());
        }
        return result.toString();
    }
}

