/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.geometry;

import java.util.Comparator;
import java.util.Objects;
import org.verapdf.wcag.algorithms.entities.content.InfoChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;

public class Vertex
extends InfoChunk {
    private final double x;
    private final double y;
    private final double radius;

    public Vertex(Integer pageNumber, double x, double y, double radius) {
        super(new BoundingBox(pageNumber, x - radius, y - radius, x + radius, y + radius));
        this.x = x;
        this.y = y;
        this.radius = radius;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getRadius() {
        return this.radius;
    }

    public static boolean areCloseVertexes(Vertex v1, Vertex v2) {
        return Vertex.areCloseVertexes(v1, v2, 0.5 * (v1.radius + v2.radius));
    }

    public static boolean areCloseVertexes(Vertex v1, Vertex v2, double epsilon) {
        return NodeUtils.areCloseNumbers(v1.x, v2.x, epsilon) && NodeUtils.areCloseNumbers(v1.y, v2.y, epsilon);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        Vertex that = (Vertex)o;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0 && Double.compare(that.radius, this.radius) == 0;
    }

    public String toString() {
        return "Vertex{x=" + this.x + ", y=" + this.y + ", radius=" + this.radius + '}';
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.x, this.y, this.radius);
    }

    public static class VertexComparatorY
    implements Comparator<Vertex> {
        @Override
        public int compare(Vertex vertex1, Vertex vertex2) {
            return -Double.compare(vertex1.getTopY(), vertex2.getTopY());
        }
    }

    public static class VertexComparatorX
    implements Comparator<Vertex> {
        @Override
        public int compare(Vertex vertex1, Vertex vertex2) {
            return Double.compare(vertex1.getLeftX(), vertex2.getLeftX());
        }
    }
}

