/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.tables;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.verapdf.wcag.algorithms.entities.content.LineChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.Vertex;

public class TableBorderBuilder {
    private final BoundingBox boundingBox;
    private final Set<Vertex> vertexes = new HashSet<Vertex>();
    private final TreeSet<LineChunk> horizontalLines = new TreeSet<LineChunk>(new LineChunk.HorizontalLineComparator());
    private final TreeSet<LineChunk> verticalLines = new TreeSet<LineChunk>(new LineChunk.VerticalLineComparator());

    public TableBorderBuilder(LineChunk lineChunk) {
        this.boundingBox = new BoundingBox(lineChunk.getBoundingBox());
        this.addLine(lineChunk);
    }

    public void addVertex(Vertex v) {
        this.vertexes.add(v);
    }

    public void addLine(LineChunk lineChunk) {
        if (lineChunk.isHorizontalLine()) {
            this.horizontalLines.add(lineChunk);
        } else {
            this.verticalLines.add(lineChunk);
        }
        this.boundingBox.union(lineChunk.getBoundingBox());
        this.addVertex(lineChunk.getStart());
        this.addVertex(lineChunk.getEnd());
    }

    public boolean isConnectedBorder(TableBorderBuilder border) {
        return this.boundingBox.overlaps(border.boundingBox);
    }

    public void mergeBorder(TableBorderBuilder border) {
        Vertex v;
        for (LineChunk horizontalLine : border.getHorizontalLines()) {
            for (LineChunk verticalLine : this.verticalLines) {
                v = LineChunk.getIntersectionVertex(horizontalLine, verticalLine);
                if (v == null) continue;
                this.vertexes.add(v);
            }
        }
        for (LineChunk horizontalLine : this.horizontalLines) {
            for (LineChunk verticalLine : border.getVerticalLines()) {
                v = LineChunk.getIntersectionVertex(horizontalLine, verticalLine);
                if (v == null) continue;
                this.vertexes.add(v);
            }
        }
        this.verticalLines.addAll(border.getVerticalLines());
        this.horizontalLines.addAll(border.getHorizontalLines());
        this.boundingBox.union(border.boundingBox);
        this.vertexes.addAll(border.getVertexes());
    }

    public int getVertexesNumber() {
        return this.vertexes.size();
    }

    public Set<LineChunk> getVerticalLines() {
        return this.verticalLines;
    }

    public Set<LineChunk> getHorizontalLines() {
        return this.horizontalLines;
    }

    public int getVerticalLinesNumber() {
        return this.verticalLines.size();
    }

    public int getHorizontalLinesNumber() {
        return this.horizontalLines.size();
    }

    public Set<Vertex> getVertexes() {
        return this.vertexes;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }
}

