/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.consumers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.SemanticCaption;
import org.verapdf.wcag.algorithms.entities.SemanticHeading;
import org.verapdf.wcag.algorithms.entities.SemanticImageNode;
import org.verapdf.wcag.algorithms.entities.SemanticNumberHeading;
import org.verapdf.wcag.algorithms.entities.SemanticParagraph;
import org.verapdf.wcag.algorithms.entities.SemanticSpan;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.ImageChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.maps.AccumulatedNodeMapper;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ChunksMergeUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ListLabelsUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ListUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TextChunkUtils;

public class AccumulatedNodeConsumer
implements Consumer<INode> {
    private static final Logger LOGGER = Logger.getLogger(AccumulatedNodeConsumer.class.getCanonicalName());
    public static final double MERGE_PROBABILITY_THRESHOLD = 0.75;
    private final AccumulatedNodeMapper accumulatedNodeMapper = new AccumulatedNodeMapper();

    @Override
    public void accept(INode node) {
        if (node.getChildren().isEmpty()) {
            this.updateNode(node, node, 1.0, node.getSemanticType());
            return;
        }
        boolean isLeafChild = node.getChildren().stream().allMatch(child -> child instanceof SemanticSpan || child instanceof SemanticImageNode || child.getSemanticType() == null);
        if (isLeafChild && node.getInitialSemanticType() == SemanticType.SPAN) {
            this.acceptSemanticSpan(node);
        } else {
            this.acceptSemanticParagraph(node);
        }
        this.acceptSemanticImage(node);
        this.checkSemanticSpanChildren(node);
        if (!isLeafChild) {
            this.acceptChildrenSemanticHeading(node);
            this.acceptSemanticList(node);
            this.acceptChildrenSemanticCaption(node);
        }
    }

    private void checkSemanticSpanChildren(INode node) {
        INode accumulatedNode = this.accumulatedNodeMapper.get(node);
        if (!(accumulatedNode instanceof SemanticTextNode)) {
            return;
        }
        if (node.getChildren().stream().noneMatch(child -> child instanceof SemanticSpan)) {
            return;
        }
        SemanticTextNode textNode = (SemanticTextNode)accumulatedNode;
        for (INode child2 : node.getChildren()) {
            if (!(child2 instanceof SemanticSpan)) continue;
            for (TextLine textLine : ((SemanticSpan)child2).getLines()) {
                for (TextChunk textChunk : textLine.getTextChunks()) {
                    if (TextChunkUtils.isWhiteSpaceChunk(textChunk) || Objects.equals(textNode.getFontSize(), textChunk.getFontSize()) && Objects.equals(textNode.getItalicAngle(), textChunk.getItalicAngle()) && Objects.equals(textNode.getFontName(), textChunk.getFontName()) && Arrays.equals(textNode.getTextColor(), textChunk.getFontColor())) continue;
                    textChunk.setHasSpecialStyle();
                }
            }
        }
    }

    private void acceptSemanticImage(INode node) {
        INode imageNode = null;
        for (INode child : node.getChildren()) {
            INode accumulatedChild = this.accumulatedNodeMapper.get(child);
            if (accumulatedChild instanceof SemanticTextNode) {
                if (((SemanticTextNode)accumulatedChild).isEmpty() || ((SemanticTextNode)accumulatedChild).isSpaceNode()) continue;
                return;
            }
            if (!(accumulatedChild instanceof SemanticImageNode)) continue;
            if (imageNode != null) {
                return;
            }
            imageNode = accumulatedChild;
        }
        if (imageNode != null) {
            this.updateNode(node, imageNode, imageNode.getCorrectSemanticScore(), imageNode.getSemanticType());
        }
    }

    private void acceptSemanticSpan(INode node) {
        double spanProbability = 1.0;
        SemanticSpan span = null;
        for (INode child : node.getChildren()) {
            if (child.getSemanticType() == null || SemanticType.isIgnoredStandardType(child.getInitialSemanticType())) continue;
            INode accumulatedChild = this.accumulatedNodeMapper.get(child);
            if (span == null) {
                span = this.buildSpanFromNode(accumulatedChild);
                spanProbability = accumulatedChild.getCorrectSemanticScore();
                continue;
            }
            spanProbability = Math.min(spanProbability, this.toSpanMergeProbability(span, accumulatedChild));
        }
        this.updateNode(node, span, spanProbability, SemanticType.SPAN);
    }

    private SemanticSpan buildSpanFromNode(INode node) {
        if (this.isNullableSemanticType(node)) {
            return null;
        }
        switch (node.getSemanticType()) {
            case SPAN: {
                return new SemanticSpan((SemanticSpan)node);
            }
        }
        return null;
    }

    private double toSpanMergeProbability(SemanticSpan span, INode node) {
        if (this.isNullableSemanticType(node)) {
            return 0.0;
        }
        switch (node.getSemanticType()) {
            case SPAN: {
                return this.toSpanMergeProbability(span, (SemanticSpan)node);
            }
        }
        return 0.0;
    }

    private double toSpanMergeProbability(SemanticSpan span, SemanticSpan secondSpan) {
        TextLine nextLine;
        if (secondSpan.getLinesNumber() == 0) {
            return 1.0;
        }
        TextLine lastLine = span.getLastLine();
        double mergeProbability = ChunksMergeUtils.toLineMergeProbability(lastLine, nextLine = secondSpan.getFirstLine());
        if (mergeProbability < 0.75) {
            mergeProbability = span.getLinesNumber() > 1 && secondSpan.getLinesNumber() > 1 ? ChunksMergeUtils.toParagraphMergeProbability(lastLine, nextLine) : ChunksMergeUtils.mergeLeadingProbability(lastLine, nextLine);
            double toColumnsMergeProbability = ChunksMergeUtils.toColumnsMergeProbability(lastLine, nextLine);
            if (toColumnsMergeProbability > mergeProbability) {
                mergeProbability = toColumnsMergeProbability;
            }
            span.getLines().addAll(secondSpan.getLines());
        } else {
            lastLine.setNotFullLine();
            nextLine.setNotFullLine();
            lastLine = new TextLine(lastLine);
            lastLine.add(nextLine);
            span.setLastLine(lastLine);
            if (secondSpan.getLinesNumber() > 1) {
                if (span.getLinesNumber() > 2 && secondSpan.getLinesNumber() > 1) {
                    mergeProbability *= ChunksMergeUtils.toParagraphMergeProbability(span.getPenultLine(), lastLine);
                }
                if (span.getLinesNumber() > 1 && secondSpan.getLinesNumber() > 2) {
                    mergeProbability *= ChunksMergeUtils.toParagraphMergeProbability(lastLine, secondSpan.getSecondLine());
                }
                span.getLines().addAll(secondSpan.getLines().subList(1, secondSpan.getLinesNumber() - 1));
            }
        }
        span.getBoundingBox().union(secondSpan.getBoundingBox());
        return secondSpan.getCorrectSemanticScore() == null ? mergeProbability : Math.min(mergeProbability, secondSpan.getCorrectSemanticScore());
    }

    private void updateNode(INode node, INode accumulatedNode, double correctSemanticScore, SemanticType semanticType) {
        if (accumulatedNode == null) {
            node.setCorrectSemanticScore(0.0);
            return;
        }
        node.setCorrectSemanticScore(correctSemanticScore);
        node.setSemanticType(semanticType);
        node.setBoundingBox(accumulatedNode.getBoundingBox());
        accumulatedNode.setCorrectSemanticScore(correctSemanticScore);
        this.accumulatedNodeMapper.put(node, accumulatedNode);
    }

    private void acceptSemanticParagraph(INode node) {
        double paragraphProbability = 1.0;
        SemanticParagraph paragraph = null;
        for (INode child : node.getChildren()) {
            if (child.getSemanticType() == null || SemanticType.isIgnoredStandardType(child.getInitialSemanticType())) continue;
            INode accumulatedChild = this.accumulatedNodeMapper.get(child);
            if (paragraph == null) {
                paragraph = this.buildParagraphFromNode(accumulatedChild);
                paragraphProbability = accumulatedChild.getCorrectSemanticScore();
                continue;
            }
            paragraphProbability = Math.min(paragraphProbability, this.toParagraphMergeProbability(paragraph, accumulatedChild));
        }
        this.updateNode(node, paragraph, paragraphProbability, SemanticType.PARAGRAPH);
    }

    private SemanticParagraph buildParagraphFromNode(INode node) {
        if (this.isNullableSemanticType(node)) {
            return null;
        }
        switch (node.getSemanticType()) {
            case SPAN: {
                SemanticSpan span = (SemanticSpan)node;
                return new SemanticParagraph(span.getBoundingBox(), span.getLines());
            }
            case PARAGRAPH: {
                return new SemanticParagraph((SemanticParagraph)node);
            }
        }
        return null;
    }

    private double toParagraphMergeProbability(SemanticParagraph paragraph, INode node) {
        if (this.isNullableSemanticType(node)) {
            return 0.0;
        }
        switch (node.getSemanticType()) {
            case SPAN: {
                return this.toParagraphMergeProbability(paragraph, (SemanticSpan)node);
            }
            case PARAGRAPH: {
                return this.toParagraphMergeProbability(paragraph, (SemanticParagraph)node);
            }
        }
        return 0.0;
    }

    private boolean isNullableSemanticType(INode node) {
        if (node.getSemanticType() == null) {
            LOGGER.log(Level.WARNING, "Node with nullable semantic type: {}", node);
            return true;
        }
        return false;
    }

    private double toParagraphMergeProbability(SemanticParagraph paragraph, List<TextLine> lines) {
        TextLine nextLine;
        if (lines.isEmpty()) {
            return 1.0;
        }
        TextLine lastLine = paragraph.getLastLine();
        double mergeProbability = ChunksMergeUtils.toLineMergeProbability(lastLine, nextLine = lines.get(0));
        if (mergeProbability < 0.75) {
            mergeProbability = paragraph.getLines().size() > 1 && lines.size() > 1 ? ChunksMergeUtils.toParagraphMergeProbability(lastLine, nextLine) : ChunksMergeUtils.mergeLeadingProbability(lastLine, nextLine);
            double toColumnsMergeProbability = ChunksMergeUtils.toColumnsMergeProbability(lastLine, nextLine);
            if (toColumnsMergeProbability > mergeProbability) {
                mergeProbability = toColumnsMergeProbability;
            }
            paragraph.getLines().addAll(lines);
        } else {
            lastLine.setNotFullLine();
            nextLine.setNotFullLine();
            lastLine = new TextLine(lastLine);
            lastLine.add(nextLine);
            paragraph.setLastLine(lastLine);
            if (lines.size() > 1) {
                if (paragraph.getLinesNumber() > 2 && lines.size() > 1) {
                    mergeProbability *= ChunksMergeUtils.toParagraphMergeProbability(paragraph.getPenultLine(), lastLine);
                }
                if (paragraph.getLinesNumber() > 1 && lines.size() > 2) {
                    mergeProbability *= ChunksMergeUtils.toParagraphMergeProbability(lastLine, lines.get(1));
                }
                paragraph.getLines().addAll(lines.subList(1, lines.size() - 1));
            }
        }
        return mergeProbability;
    }

    private double toParagraphMergeProbability(SemanticParagraph paragraph, SemanticSpan span) {
        double mergeProbability = this.toParagraphMergeProbability(paragraph, span.getLines());
        paragraph.getBoundingBox().union(span.getBoundingBox());
        return span.getCorrectSemanticScore() == null ? mergeProbability : Math.min(span.getCorrectSemanticScore(), mergeProbability);
    }

    private double toParagraphMergeProbability(SemanticParagraph paragraph1, SemanticParagraph paragraph2) {
        double mergeProbability = this.toParagraphMergeProbability(paragraph1, paragraph2.getLines());
        paragraph1.getBoundingBox().union(paragraph2.getBoundingBox());
        return paragraph2.getCorrectSemanticScore() == null ? mergeProbability : Math.min(paragraph2.getCorrectSemanticScore(), mergeProbability);
    }

    private void acceptChildrenSemanticHeading(INode node) {
        ArrayList<INode> children = new ArrayList<INode>(node.getChildren().size());
        for (INode child : node.getChildren()) {
            SemanticTextNode textNode;
            INode accumulatedChild;
            if (child == null || !((accumulatedChild = this.accumulatedNodeMapper.get(child)) instanceof SemanticTextNode) || (textNode = (SemanticTextNode)accumulatedChild).isSpaceNode() || textNode.isEmpty()) continue;
            children.add(child);
        }
        if (children.size() <= 1) {
            return;
        }
        this.acceptSemanticHeading((INode)children.get(0), null, (INode)children.get(1));
        for (int i = 1; i < children.size() - 1; ++i) {
            this.acceptSemanticHeading((INode)children.get(i), (INode)children.get(i - 1), (INode)children.get(i + 1));
        }
        this.acceptSemanticHeading((INode)children.get(children.size() - 1), (INode)children.get(children.size() - 2), null);
    }

    private void acceptSemanticHeading(INode node, INode previousNode, INode nextNode) {
        if (SemanticType.LIST.equals((Object)node.getSemanticType())) {
            return;
        }
        double headingProbability = NodeUtils.headingProbability(this.accumulatedNodeMapper.get(node), this.accumulatedNodeMapper.get(previousNode), this.accumulatedNodeMapper.get(nextNode), node.getInitialSemanticType());
        if (headingProbability >= 0.75) {
            INode accumulatedNode = this.accumulatedNodeMapper.get(node);
            if (node.getInitialSemanticType() == SemanticType.NUMBER_HEADING) {
                if (accumulatedNode instanceof SemanticSpan) {
                    this.updateNode(node, new SemanticNumberHeading((SemanticSpan)accumulatedNode), headingProbability * node.getCorrectSemanticScore(), SemanticType.NUMBER_HEADING);
                } else if (accumulatedNode instanceof SemanticParagraph) {
                    this.updateNode(node, new SemanticNumberHeading((SemanticParagraph)accumulatedNode), headingProbability * node.getCorrectSemanticScore(), SemanticType.NUMBER_HEADING);
                }
            } else if (accumulatedNode instanceof SemanticSpan) {
                this.updateNode(node, new SemanticHeading((SemanticSpan)accumulatedNode), headingProbability * node.getCorrectSemanticScore(), SemanticType.HEADING);
            } else if (accumulatedNode instanceof SemanticParagraph) {
                this.updateNode(node, new SemanticHeading((SemanticParagraph)accumulatedNode), headingProbability * node.getCorrectSemanticScore(), SemanticType.HEADING);
            }
        }
    }

    private void acceptChildrenSemanticCaption(INode node) {
        ArrayList<INode> children = new ArrayList<INode>(node.getChildren().size());
        for (INode child : node.getChildren()) {
            if (child == null) continue;
            INode accumulatedChild = this.accumulatedNodeMapper.get(child);
            if (accumulatedChild instanceof SemanticTextNode) {
                SemanticTextNode textNode = (SemanticTextNode)accumulatedChild;
                if (textNode.isSpaceNode() || textNode.isEmpty()) continue;
                children.add(child);
                continue;
            }
            if (!(accumulatedChild instanceof SemanticImageNode)) continue;
            children.add(child);
        }
        if (children.size() <= 1) {
            return;
        }
        for (int i = 0; i < children.size() - 1; ++i) {
            this.acceptSemanticCaption((INode)children.get(i), (INode)children.get(i + 1));
            this.acceptSemanticCaption((INode)children.get(i + 1), (INode)children.get(i));
        }
    }

    private void acceptSemanticCaption(INode node, INode neighborNode) {
        if (node.getSemanticType() == SemanticType.HEADING || node.getSemanticType() == SemanticType.NUMBER_HEADING) {
            return;
        }
        INode accumulatedNode = this.accumulatedNodeMapper.get(node);
        double captionProbability = NodeUtils.captionProbability(accumulatedNode, this.accumulatedNodeMapper.get(neighborNode));
        if (captionProbability >= 0.75) {
            this.updateNode(node, new SemanticCaption((SemanticTextNode)accumulatedNode), captionProbability * node.getCorrectSemanticScore(), SemanticType.CAPTION);
        }
    }

    private void acceptSemanticList(INode node) {
        ArrayList<INode> textChildren = new ArrayList<INode>(node.getChildren().size());
        ArrayList<TextLine> childrenFirstLines = new ArrayList<TextLine>(node.getChildren().size());
        ArrayList<INode> imageChildren = new ArrayList<INode>(node.getChildren().size());
        ArrayList<ImageChunk> childrenImages = new ArrayList<ImageChunk>(node.getChildren().size());
        for (INode child : node.getChildren()) {
            TextLine line;
            SemanticTextNode textNode;
            if (child == null) continue;
            INode newChild = child;
            while (!newChild.getChildren().isEmpty()) {
                newChild = newChild.getChildren().get(0);
            }
            if (newChild instanceof SemanticImageNode) {
                imageChildren.add(child);
                childrenImages.add(((SemanticImageNode)newChild).getImage());
                continue;
            }
            INode accumulatedChild = this.accumulatedNodeMapper.get(child);
            if (!(accumulatedChild instanceof SemanticTextNode) || (textNode = (SemanticTextNode)accumulatedChild).isSpaceNode() || textNode.isEmpty() || (line = textNode.getFirstLine()).getValue().trim().isEmpty()) continue;
            textChildren.add(child);
            childrenFirstLines.add(line);
        }
        if (textChildren.size() > 1) {
            ArrayList<String> listItems = new ArrayList<String>(node.getChildren().size());
            for (TextLine line : childrenFirstLines) {
                listItems.add(line.getValue().trim());
            }
            ListUtils.updateTreeWithRecognizedList(node, textChildren, ListUtils.getChildrenListIntervals(ListLabelsUtils.getListItemsIntervals(listItems), childrenFirstLines));
        }
        if (imageChildren.size() > 1) {
            ListUtils.updateTreeWithRecognizedList(node, imageChildren, ListUtils.getChildrenListIntervals(ListLabelsUtils.getImageListItemsIntervals(childrenImages), childrenImages));
        }
    }
}

