/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.tables;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.tables.TableToken;
import org.verapdf.wcag.algorithms.entities.tables.TableTokenRow;
import org.verapdf.wcag.algorithms.semanticalgorithms.tables.TableCluster;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ChunksMergeUtils;

public class TableRecognitionArea {
    private double adaptiveNextLineToleranceFactor = 1.05;
    private boolean hasCompleteHeaders = false;
    private boolean isComplete = false;
    private boolean isValid = false;
    private List<TableCluster> headers = new ArrayList<TableCluster>();
    private List<TableCluster> clusters = new ArrayList<TableCluster>();
    BoundingBox boundingBox;
    double headersBaseLine = Double.MAX_VALUE;
    double baseLine = Double.MAX_VALUE;

    public TableRecognitionArea() {
        this.boundingBox = new BoundingBox();
    }

    public void setPageNumber(int pageNumber) {
        this.boundingBox.setPageNumber(pageNumber);
    }

    public Integer getPageNumber() {
        return this.boundingBox.getPageNumber();
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public boolean hasCompleteHeaders() {
        return this.hasCompleteHeaders;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public List<TableCluster> getHeaders() {
        return this.headers;
    }

    public List<TableCluster> getClusters() {
        return this.clusters;
    }

    public void addTokenToRecognitionArea(TableToken token) {
        if (this.isComplete) {
            return;
        }
        if (token.getPageNumber() == null) {
            return;
        }
        if (this.boundingBox.getPageNumber() == null) {
            this.boundingBox.setPageNumber(token.getPageNumber());
        } else if (!this.boundingBox.getPageNumber().equals(token.getPageNumber())) {
            this.isComplete = true;
            this.hasCompleteHeaders = true;
            this.headersBaseLine = this.baseLine;
            return;
        }
        if (this.hasCompleteHeaders) {
            this.addCluster(token);
        } else if (this.belongsToHeadersArea(token)) {
            this.expandHeaders(token);
        } else {
            this.hasCompleteHeaders = true;
            this.headersBaseLine = this.baseLine;
            if (this.checkHeaders()) {
                this.addCluster(token);
            } else {
                this.isComplete = true;
            }
        }
    }

    private boolean checkHeaders() {
        if (this.headers.size() < 2) {
            return false;
        }
        double avrFirstBaseLine = 0.0;
        double avrLastBaseLine = 0.0;
        double avrCenter = 0.0;
        for (TableCluster header : this.headers) {
            TableTokenRow firstLine = header.getFirstRow();
            TableTokenRow lastLine = header.getLastRow();
            avrFirstBaseLine += firstLine.getBaseLine();
            avrLastBaseLine += lastLine.getBaseLine();
            avrCenter += 0.5 * (firstLine.getBaseLine() + lastLine.getBaseLine());
        }
        avrFirstBaseLine /= (double)this.headers.size();
        avrLastBaseLine /= (double)this.headers.size();
        avrCenter /= (double)this.headers.size();
        double maxTopDeviation = 0.0;
        double maxBottomDeviation = 0.0;
        double maxCenterDeviation = 0.0;
        for (TableCluster header : this.headers) {
            TableTokenRow firstLine = header.getFirstRow();
            TableTokenRow lastLine = header.getLastRow();
            double fontSize = firstLine.getFontSize();
            double topDeviation = Math.abs(avrFirstBaseLine - firstLine.getBaseLine()) / fontSize;
            double bottomDeviation = Math.abs(avrLastBaseLine - lastLine.getBaseLine()) / fontSize;
            double centerDeviation = Math.abs(avrCenter - 0.5 * (firstLine.getBaseLine() + lastLine.getBaseLine())) / fontSize;
            if (maxTopDeviation < topDeviation) {
                maxTopDeviation = topDeviation;
            }
            if (maxBottomDeviation < bottomDeviation) {
                maxBottomDeviation = bottomDeviation;
            }
            if (!(maxCenterDeviation < centerDeviation)) continue;
            maxCenterDeviation = centerDeviation;
        }
        double headersProbability = 1.0 - Math.min(Math.min(maxTopDeviation, maxBottomDeviation), maxCenterDeviation);
        return headersProbability > 0.75;
    }

    private boolean belongsToHeadersArea(TableToken token) {
        if (this.headers.isEmpty()) {
            return true;
        }
        if (this.baseLine - token.getBaseLine() > this.adaptiveNextLineToleranceFactor * token.getFontSize()) {
            return false;
        }
        return !(token.getBottomY() > this.boundingBox.getTopY() + 3.0 * token.getFontSize());
    }

    private void expandHeaders(TableToken token) {
        if (this.headers.isEmpty()) {
            TableCluster header = new TableCluster(token);
            header.setHeader(header);
            this.headers.add(header);
            this.boundingBox = new BoundingBox(token.getBoundingBox());
            this.baseLine = token.getBaseLine();
            return;
        }
        TableCluster currentHeader = null;
        ArrayList<TableCluster> headersToRemove = new ArrayList<TableCluster>();
        for (TableCluster header : this.headers) {
            if (currentHeader == null) {
                if (!this.expandHeader(header, token)) continue;
                currentHeader = header;
                continue;
            }
            if (!this.joinHeaders(currentHeader, header, token)) continue;
            headersToRemove.add(header);
        }
        if (currentHeader == null) {
            TableCluster header = new TableCluster(token);
            header.setHeader(header);
            this.headers.add(header);
            this.boundingBox.union(token.getBoundingBox());
            if (token.getBaseLine() < this.baseLine) {
                this.baseLine = token.getBaseLine();
            }
        } else {
            this.headers.removeAll(headersToRemove);
        }
    }

    private boolean expandHeader(TableCluster header, TableToken token) {
        double lineSpacingFactor;
        double tokenBaseLine;
        double headerBaseLine = header.getBaseLine();
        double baseLineDiff = Math.abs(headerBaseLine - (tokenBaseLine = token.getBaseLine()));
        if (baseLineDiff < 0.9 * token.getFontSize() && ChunksMergeUtils.toLineMergeProbability(header.getLastToken(), token) > 0.75) {
            header.add(token);
            if (token.getBaseLine() < this.baseLine) {
                this.baseLine = token.getBaseLine();
            }
            return true;
        }
        BoundingBox headerBBox = header.getBoundingBox();
        if (headerBBox.getLeftX() < token.getRightX() && token.getLeftX() < headerBBox.getRightX() && (lineSpacingFactor = baseLineDiff / token.getFontSize()) < 1.5) {
            if (this.adaptiveNextLineToleranceFactor < lineSpacingFactor) {
                this.adaptiveNextLineToleranceFactor = lineSpacingFactor * 1.05;
            }
            header.add(token, true);
            if (token.getBaseLine() < this.baseLine) {
                this.baseLine = token.getBaseLine();
            }
            return true;
        }
        return false;
    }

    private boolean joinHeaders(TableCluster currentHeader, TableCluster header, TableToken token) {
        BoundingBox headerBBox = header.getBoundingBox();
        if (headerBBox.getLeftX() < token.getRightX() && token.getLeftX() < headerBBox.getRightX()) {
            currentHeader.mergeWithoutRowNumbers(header);
            this.boundingBox.union(token.getBoundingBox());
            if (token.getBaseLine() < this.baseLine) {
                this.baseLine = token.getBaseLine();
            }
            return true;
        }
        return false;
    }

    private void addCluster(TableToken token) {
        if (this.baseLine - token.getBaseLine() > 3.0 * token.getFontSize() || this.headersBaseLine < token.getBaseLine()) {
            this.isComplete = true;
            return;
        }
        TableCluster cluster = new TableCluster(token);
        this.clusters.add(cluster);
        this.boundingBox.union(cluster.getBoundingBox());
        if (cluster.getBaseLine() < this.baseLine) {
            this.baseLine = cluster.getBaseLine();
        }
        this.isValid = true;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("TableRecognitionArea{\n");
        result.append("    headers={\n");
        for (TableCluster header : this.headers) {
            result.append('[').append(header).append("]\n");
        }
        result.append("    }, clusters={\n");
        for (TableCluster cluster : this.clusters) {
            result.append('[').append(cluster).append("] : [").append(String.valueOf(cluster.getHeader())).append("]\n");
        }
        result.append("    }, boundingBox=").append(this.boundingBox).append('\n');
        result.append("    , baseLine=").append(this.baseLine).append("\n}");
        return result.toString();
    }
}

