/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.tables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.tables.Table;
import org.verapdf.wcag.algorithms.entities.tables.TableCell;
import org.verapdf.wcag.algorithms.entities.tables.TableRow;
import org.verapdf.wcag.algorithms.entities.tables.TableTokenRow;
import org.verapdf.wcag.algorithms.semanticalgorithms.tables.TableCluster;
import org.verapdf.wcag.algorithms.semanticalgorithms.tables.TableClusterGap;
import org.verapdf.wcag.algorithms.semanticalgorithms.tables.TableRecognitionArea;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TableUtils;

public class TableRecognizer {
    private Long clusterCounter = 0L;
    private final List<TableCluster> headers;
    private List<TableCluster> clusters;
    private final Map<TableCluster, TableCluster> columns;
    private Integer numRows = null;
    private Table table = null;

    public TableRecognizer(TableRecognitionArea recognitionArea) {
        this.headers = recognitionArea.getHeaders();
        this.clusters = recognitionArea.getClusters();
        this.columns = new HashMap<TableCluster, TableCluster>();
    }

    public void recognize() {
        this.preprocess();
        this.calculateInitialColumns();
        this.mergeWeakClusters();
        this.mergeClustersByMinGaps();
        this.postprocess();
    }

    private void mergeClustersByMinGaps() {
        int numClusters = 0;
        while (numClusters != this.clusters.size()) {
            numClusters = this.clusters.size();
            for (TableCluster cluster : this.clusters) {
                if (cluster.getId() == null || cluster.getMinRightGap() == null) continue;
                TableClusterGap rightGap = cluster.getMinRightGap();
                TableClusterGap leftGap = cluster.getMinLeftGap();
                TableCluster nextCluster = rightGap.getLink();
                TableClusterGap nextRightGap = nextCluster.getMinRightGap();
                TableClusterGap nextLeftGap = nextCluster.getMinLeftGap();
                if (cluster != nextLeftGap.getLink() || cluster.getHeader() != null && nextCluster.getHeader() != null || leftGap != null && !(rightGap.getGap() < leftGap.getGap()) || nextRightGap != null && !(nextLeftGap.getGap() < nextRightGap.getGap())) continue;
                if (nextCluster.getHeader() != null) {
                    nextCluster.merge(cluster, true);
                    cluster.setId(null);
                    continue;
                }
                cluster.merge(nextCluster, true);
                nextCluster.setId(null);
            }
            this.clusters = this.getActualClusters(this.clusters);
        }
    }

    private void calculateInitialColumns() {
        for (TableCluster cluster : this.clusters) {
            if (cluster.getHeader() == null) {
                this.setupStrongHeaderForCluster(cluster);
            }
            this.addClusterToColumnByHeader(cluster);
        }
        this.clusters = this.getActualClusters(this.clusters);
    }

    private void setupStrongHeaderForCluster(TableCluster cluster) {
        TableCluster containingHeader = null;
        for (TableCluster header : this.headers) {
            if (!TableUtils.isContaining(cluster, header)) continue;
            if (containingHeader != null) {
                return;
            }
            containingHeader = header;
        }
        cluster.setHeader(containingHeader);
    }

    private void addClusterToColumnByHeader(TableCluster cluster) {
        TableCluster header = cluster.getHeader();
        if (header == null) {
            return;
        }
        if (this.columns.containsKey(header)) {
            TableCluster originalCluster = this.columns.get(header);
            originalCluster.merge(cluster, true);
            cluster.setId(null);
        } else {
            this.columns.put(header, cluster);
        }
    }

    private void mergeWeakClusters() {
        int position = this.getNextWeakCluster(0);
        while (position < this.clusters.size()) {
            TableCluster cluster = this.clusters.get(position);
            TableCluster closestHeader = null;
            double minDist = Double.MAX_VALUE;
            for (TableCluster header : this.headers) {
                double dist;
                double factor = 1.0;
                if (TableUtils.areStrongContaining(cluster, header)) {
                    factor = 1.0E-4;
                } else if (TableUtils.isContaining(cluster, header)) {
                    factor = 0.001;
                }
                if (TableUtils.areCenterOverlapping(cluster, header)) {
                    factor = 0.01;
                } else if (TableUtils.areOverlapping(cluster, header)) {
                    factor = 0.1;
                }
                if (!((dist = factor * Math.abs(cluster.getCenterX() - header.getCenterX())) < minDist)) continue;
                closestHeader = header;
                minDist = dist - 1.0E-18;
            }
            cluster.setHeader(closestHeader);
            this.addClusterToColumnByHeader(cluster);
            position = this.getNextWeakCluster(position + 1);
        }
        this.clusters = this.getActualClusters(this.clusters);
    }

    private int getNextWeakCluster(int position) {
        while (position < this.clusters.size()) {
            TableCluster cluster = this.clusters.get(position);
            if (TableUtils.isWeakCluster(cluster, this.headers)) {
                return position;
            }
            ++position;
        }
        return position;
    }

    private void preprocess() {
        this.setupRowAndColNumbers();
        this.calculateInitialClusters();
    }

    private void setupRowAndColNumbers() {
        for (TableCluster header : this.headers) {
            header.setId(this.generateClusterId());
        }
        ArrayList<TableCluster> cleanClusters = new ArrayList<TableCluster>();
        for (TableCluster cluster : this.clusters) {
            for (TableTokenRow row : cluster.getRows()) {
                TableCluster cleanCluster = new TableCluster(row);
                cleanCluster.setHeader(cluster.getHeader());
                cleanCluster.setId(this.generateClusterId());
                cleanClusters.add(cleanCluster);
            }
        }
        this.clusters = cleanClusters;
        TableUtils.sortClustersUpToBottom(this.clusters);
        this.setupRowNumbers();
        this.setupColNumbers();
    }

    private void setupRowNumbers() {
        int currentRow = 1;
        TableCluster firstCluster = this.clusters.get(0);
        firstCluster.setRowNumber(0, currentRow);
        for (int i = 1; i < this.clusters.size(); ++i) {
            TableCluster cluster = this.clusters.get(i);
            double fontSize = cluster.getFirstRow().getFontSize();
            double baseLineTolerance = fontSize * 0.9;
            if (firstCluster.getBaseLine() > cluster.getBaseLine() + baseLineTolerance) {
                ++currentRow;
                firstCluster = cluster;
            }
            cluster.setRowNumber(0, currentRow);
        }
        this.numRows = currentRow + 1;
    }

    private void setupColNumbers() {
        TableUtils.sortClustersLeftToRight(this.headers);
        for (int i = 0; i < this.headers.size(); ++i) {
            TableCluster header = this.headers.get(i);
            header.setColNumber(i);
        }
    }

    private void calculateInitialClusters() {
        ArrayList<List<TableCluster>> clusterRows = new ArrayList<List<TableCluster>>(this.numRows - 1);
        for (int i = 0; i < this.numRows - 1; ++i) {
            clusterRows.add(new ArrayList());
        }
        for (TableCluster cluster : this.clusters) {
            ((List)clusterRows.get(cluster.getFirstRow().getRowNumber() - 1)).add(cluster);
            if (cluster.getHeader() != null) continue;
            this.setupStrongHeaderForCluster(cluster);
        }
        this.clusters = this.mergeInitialClusters(clusterRows);
        this.updateMinGaps();
    }

    private void updateMinGaps() {
        for (TableCluster cluster : this.clusters) {
            cluster.updateMinGaps();
        }
    }

    private List<TableCluster> mergeInitialClusters(List<List<TableCluster>> clusterRows) {
        ArrayList<TableCluster> initialClusters = new ArrayList<TableCluster>();
        for (List<TableCluster> clusterRow : clusterRows) {
            TableUtils.sortClustersLeftToRight(clusterRow);
            for (int j = 0; j < clusterRow.size(); ++j) {
                TableCluster cluster = clusterRow.get(j);
                if (j < clusterRow.size() - 1) {
                    TableCluster nextCluster = clusterRow.get(j + 1);
                    double gap = nextCluster.getLeftX() - cluster.getRightX();
                    cluster.getFirstRow().setRightGap(new TableClusterGap(nextCluster, gap));
                    nextCluster.getFirstRow().setLeftGap(new TableClusterGap(cluster, gap));
                }
                boolean merged = false;
                for (TableCluster initialCluster : initialClusters) {
                    if (initialCluster.getId() == null) continue;
                    if (cluster.getHeader() != null && cluster.getHeader() == initialCluster.getHeader()) {
                        initialCluster.merge(cluster, false);
                        cluster.setId(null);
                        cluster = initialCluster;
                        merged = true;
                        continue;
                    }
                    if (cluster.getHeader() != null && initialCluster.getHeader() != null || !TableUtils.isAnyContaining(cluster, initialCluster) && !TableUtils.areStrongCenterOverlapping(cluster, initialCluster)) continue;
                    initialCluster.merge(cluster, false);
                    cluster.setId(null);
                    cluster = initialCluster;
                    merged = true;
                }
                if (merged) continue;
                initialClusters.add(cluster);
            }
        }
        return this.getActualClusters(initialClusters);
    }

    private List<TableCluster> getActualClusters(List<TableCluster> oldClusters) {
        ArrayList<TableCluster> actualClusters = new ArrayList<TableCluster>();
        for (TableCluster cluster : oldClusters) {
            if (cluster.getId() == null) continue;
            actualClusters.add(cluster);
        }
        return actualClusters;
    }

    public Table getTable() {
        return this.table;
    }

    public void postprocess() {
        if (this.headers.size() < this.clusters.size()) {
            return;
        }
        for (TableCluster cluster : this.clusters) {
            TableCluster header = cluster.getHeader();
            if (header != null && header.getColNumber() != null) continue;
            return;
        }
        this.table = this.constructTable();
    }

    private void updateColumns() {
        for (TableCluster cluster : this.clusters) {
            cluster.sortAndMergeRows();
            cluster.setColNumber(cluster.getHeader().getColNumber());
        }
    }

    private Table constructTable() {
        this.updateColumns();
        Table table = new Table(this.headers);
        ArrayList<Integer> rowIds = new ArrayList<Integer>(Collections.nCopies(this.headers.size(), 0));
        for (TableCluster cluster : this.clusters) {
            rowIds.add(cluster.getFirstRow().getRowNumber());
        }
        for (int i = 1; i < this.numRows; ++i) {
            TableRow tableRow = new TableRow(SemanticType.TABLE_BODY);
            for (Map.Entry<TableCluster, TableCluster> entry : this.columns.entrySet()) {
                TableCluster column = entry.getValue();
                if (column == null || (Integer)rowIds.get(column.getColNumber()) >= column.getRows().size()) {
                    tableRow.add(new TableCell(SemanticType.TABLE_CELL));
                    continue;
                }
                int rowId = (Integer)rowIds.get(column.getColNumber());
                Integer rowNumber = column.getRows().get(rowId).getRowNumber();
                if (rowNumber == null || rowNumber <= i) {
                    if (rowNumber == i) {
                        tableRow.add(new TableCell(column.getRows().get(rowId), SemanticType.TABLE_CELL));
                    }
                    rowIds.set(column.getColNumber(), rowId + 1);
                    continue;
                }
                tableRow.add(new TableCell(SemanticType.TABLE_CELL));
            }
            table.add(tableRow);
        }
        table.updateTableRows();
        if (table.getValidationScore() < 0.75) {
            return null;
        }
        return table;
    }

    private Long generateClusterId() {
        Long l = this.clusterCounter;
        Long l2 = this.clusterCounter = Long.valueOf(this.clusterCounter + 1L);
        return l;
    }
}

