/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.utils;

import java.util.Arrays;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextLine;

public class ChunksMergeUtils {
    private static final double FLOATING_POINT_OPERATIONS_EPS = 1.0E-7;
    private static final double FONT_METRIC_UNIVERSAL_TEMPORARY_THRESHOLD = 0.1;
    private static final double FONT_SIZE_COMPARISON_THRESHOLD = 0.05;
    private static final double FONT_WHITESPACE_COMPARISON_THRESHOLD = 0.33;
    private static final double FONT_LEADING_INTERVAL_STANDARD = 1.0;
    private static final double[] DEFAULT_FONT_CHAR_SPACING_INTERVAL = new double[]{0.0, 0.67};
    private static final double[] DEFAULT_FONT_LEADING_INTERVAL = new double[]{0.0, 1.5};
    private static final double TO_LINE_PROBABILITY_THRESHOLD = 0.75;
    private static final double[] NORMAL_LINE_PROBABILITY_PARAMS = new double[]{2.0, 0.033};
    private static final double[] SUPERSCRIPT_PROBABILITY_PARAMS = new double[]{0.69438, 1.70575, 1.43819};
    private static final double[] SUBSCRIPT_PROBABILITY_PARAMS = new double[]{0.71932, 1.0483, 0.37555};
    private static final double SUPERSCRIPT_BASELINE_THRESHOLD = 0.1;
    private static final double SUPERSCRIPT_FONTSIZE_THRESHOLD = 0.1;
    private static final double SUBSCRIPT_BASELINE_THRESHOLD = 0.1;
    private static final double SUBSCRIPT_FONTSIZE_THRESHOLD = 0.1;

    private ChunksMergeUtils() {
    }

    public static double toChunkMergeProbability(TextChunk x, TextChunk y) {
        double resultProbability = 1.0;
        resultProbability *= ChunksMergeUtils.mergeByFontNameProbability(x, y);
        resultProbability *= ChunksMergeUtils.mergeByFontSizeProbability(x, y);
        resultProbability *= ChunksMergeUtils.mergeByFontColorProbability(x, y);
        resultProbability *= ChunksMergeUtils.mergeByBaseLineProbability(x, y);
        return resultProbability *= ChunksMergeUtils.mergeByCharSpacingProbability(x, y);
    }

    public static double toLineMergeProbability(TextChunk x, TextChunk y) {
        double baseLineDiff = x.getBaseLine() - y.getBaseLine();
        double fontSizeDiff = x.getFontSize() - y.getFontSize();
        double maxFontSize = Math.max(x.getFontSize(), y.getFontSize());
        baseLineDiff /= maxFontSize;
        fontSizeDiff /= maxFontSize;
        double charSpacingProbability = ChunksMergeUtils.mergeByCharSpacingProbability(x, y);
        double resultProbability = charSpacingProbability * ChunksMergeUtils.mergeNormalLineProbability(Math.abs(baseLineDiff), Math.abs(fontSizeDiff), NORMAL_LINE_PROBABILITY_PARAMS);
        if (resultProbability < 0.75 && charSpacingProbability > 0.75) {
            double superscriptProbability = charSpacingProbability;
            double subscriptProbability = charSpacingProbability;
            superscriptProbability = fontSizeDiff > 0.1 && baseLineDiff < -0.1 || fontSizeDiff < -0.1 && baseLineDiff > 0.1 ? (superscriptProbability *= ChunksMergeUtils.toLineProbabilityFunction(Math.abs(baseLineDiff), Math.abs(fontSizeDiff), SUPERSCRIPT_PROBABILITY_PARAMS)) : 0.0;
            subscriptProbability = fontSizeDiff > 0.1 && baseLineDiff > 0.1 || fontSizeDiff < -0.1 && baseLineDiff < -0.1 ? (subscriptProbability *= ChunksMergeUtils.toLineProbabilityFunction(Math.abs(baseLineDiff), Math.abs(fontSizeDiff), SUBSCRIPT_PROBABILITY_PARAMS)) : 0.0;
            return Math.max(resultProbability, Math.max(superscriptProbability, subscriptProbability));
        }
        return resultProbability;
    }

    private static double mergeNormalLineProbability(double x, double y, double[] params) {
        return 1.0 - params[0] * x - params[1] * y;
    }

    private static double toLineProbabilityFunction(double x, double y, double[] params) {
        double result = 1.0 - params[0] * x * x - (params[1] * y - params[2] * x) * y;
        return result;
    }

    public static double toLineMergeProbability(TextLine x, TextLine y) {
        return ChunksMergeUtils.toLineMergeProbability(x.getLastTextChunk(), y.getFirstTextChunk());
    }

    public static double toParagraphMergeProbability(TextLine x, TextLine y) {
        double resultProbability = 1.0;
        resultProbability *= ChunksMergeUtils.mergeLeadingProbability(x, y);
        return resultProbability *= ChunksMergeUtils.mergeIndentationProbability(x, y);
    }

    public static double toColumnsMergeProbability(TextLine x, TextLine y) {
        if (Math.abs(x.getFontSize() - y.getFontSize()) > 0.95) {
            return 0.0;
        }
        if (x.getLastPageNumber() == null || y.getPageNumber() == null) {
            return 0.0;
        }
        if (x.getLastPageNumber() > y.getPageNumber()) {
            return 0.0;
        }
        if (x.getLastPageNumber().equals(y.getPageNumber()) && x.getRightX() > y.getLeftX()) {
            return 0.0;
        }
        return ChunksMergeUtils.mergeByFontSizeProbability(x, y);
    }

    public static double mergeLeadingProbability(TextLine x, TextLine y) {
        if (Math.abs(x.getFontSize() - y.getFontSize()) > 0.95) {
            return 0.0;
        }
        if (x.getLastPageNumber() == null || y.getPageNumber() == null) {
            return 0.0;
        }
        if (x.getLastPageNumber() < y.getPageNumber()) {
            return 1.0;
        }
        if (!x.getLastPageNumber().equals(y.getPageNumber())) {
            return 0.0;
        }
        double maxFontSize = Math.max(x.getFontSize(), y.getFontSize());
        double baseLineDifference = Math.abs(x.getBaseLine() - y.getBaseLine());
        return ChunksMergeUtils.getUniformProbability(DEFAULT_FONT_LEADING_INTERVAL, baseLineDifference / maxFontSize, 1.0);
    }

    private static double mergeByFontNameProbability(TextChunk x, TextChunk y) {
        return x.getFontName().equals(y.getFontName()) ? 1.0 : 0.0;
    }

    private static double mergeByFontSizeProbability(TextChunk x, TextChunk y) {
        double fontSize2;
        double fontSize1 = x.getFontSize();
        double ratio = fontSize1 < (fontSize2 = y.getFontSize()) ? fontSize1 / fontSize2 : fontSize2 / fontSize1;
        return ChunksMergeUtils.getUniformProbability(new double[]{1.0, 1.0}, ratio, 0.05);
    }

    private static double mergeByFontSizeProbability(TextLine x, TextLine y) {
        double fontSize2;
        double fontSize1 = x.getFontSize();
        double ratio = fontSize1 < (fontSize2 = y.getFontSize()) ? fontSize1 / fontSize2 : fontSize2 / fontSize1;
        return ChunksMergeUtils.getUniformProbability(new double[]{1.0, 1.0}, ratio, 0.05);
    }

    private static double mergeByFontColorProbability(TextChunk x, TextChunk y) {
        return Arrays.equals(x.getFontColor(), y.getFontColor()) ? 1.0 : 0.0;
    }

    private static double mergeByBaseLineProbability(TextChunk x, TextChunk y) {
        return ChunksMergeUtils.getUniformProbability(new double[]{0.0, 1.0E-7}, Math.abs(x.getBaseLine() - y.getBaseLine()), 0.1);
    }

    private static double mergeByCharSpacingProbability(TextChunk x, TextChunk y) {
        double leftChunkRightX = x.getRightX();
        double rightChunkLeftX = y.getLeftX();
        if (ChunksMergeUtils.lastCharIsWhitespace(x.getValue())) {
            leftChunkRightX -= ChunksMergeUtils.whitespaceSize(x.getFontSize());
        }
        if (ChunksMergeUtils.firstCharIsWhitespace(y.getValue())) {
            rightChunkLeftX += ChunksMergeUtils.whitespaceSize(y.getFontSize());
        }
        double distanceBetweenChunks = Math.abs(leftChunkRightX - rightChunkLeftX);
        double maxFontSize = Math.max(x.getFontSize(), y.getFontSize());
        return ChunksMergeUtils.getUniformProbability(DEFAULT_FONT_CHAR_SPACING_INTERVAL, distanceBetweenChunks / maxFontSize, 0.33);
    }

    public static double mergeIndentationProbability(TextLine x, TextLine y) {
        double maxFontSize = Math.max(x.getFontSize(), y.getFontSize());
        double leftXDifference = Math.abs(x.getLeftX() - y.getLeftX());
        double rightXDifference = Math.abs(x.getRightX() - y.getRightX());
        double centerXDifference = 0.5 * Math.abs(x.getRightX() + x.getLeftX() - (y.getRightX() + y.getLeftX()));
        double minDifference = Math.min(leftXDifference, rightXDifference);
        minDifference = Math.min(minDifference, centerXDifference);
        return ChunksMergeUtils.getUniformProbability(new double[]{0.0, 1.0E-7}, minDifference /= maxFontSize, 0.1);
    }

    private static double mergeYAlmostNestedProbability(TextChunk x, TextChunk y) {
        double minBottomY = Math.min(x.getBottomY(), y.getBottomY());
        double maxBottomY = Math.max(x.getBottomY(), y.getBottomY());
        double minTopY = Math.min(x.getTopY(), y.getTopY());
        double maxTopY = Math.max(x.getTopY(), y.getTopY());
        double boundingBoxYIntersection = minTopY - maxBottomY;
        double minBoundingBoxDifference = Math.min(maxBottomY - minBottomY, maxTopY - minTopY);
        double ratio = minBoundingBoxDifference / boundingBoxYIntersection;
        return ChunksMergeUtils.getUniformProbability(new double[]{0.0, 0.0}, ratio, 0.1);
    }

    public static double getUniformProbability(double[] probability1Interval, double point, double initIntervalLength) {
        if (point + 1.0E-7 > probability1Interval[0] && point < probability1Interval[1] + 1.0E-7) {
            return 1.0;
        }
        if (point < probability1Interval[0] - initIntervalLength - 1.0E-7 || point > probability1Interval[1] + initIntervalLength + 1.0E-7) {
            return 0.0;
        }
        double deviation = point < probability1Interval[0] + 1.0E-7 ? probability1Interval[0] - point : point - probability1Interval[1];
        double[] targetProbabilityInterval = new double[]{0.0, 1.0};
        double probabilityFactor = (targetProbabilityInterval[1] - targetProbabilityInterval[0]) / initIntervalLength;
        return (initIntervalLength - deviation) * probabilityFactor + targetProbabilityInterval[0];
    }

    private static boolean lastCharIsWhitespace(String str) {
        return str.length() > 0 && str.charAt(str.length() - 1) == ' ';
    }

    private static boolean firstCharIsWhitespace(String str) {
        return str.length() > 0 && Character.isWhitespace(str.charAt(0));
    }

    private static double whitespaceSize(double fontSize) {
        return 0.25 * fontSize;
    }
}

