/**
 * This file is part of veraPDF wcag algorithms, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF wcag algorithms is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF wcag algorithms as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF wcag algorithms as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.wcag.algorithms.entities;

import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;

import java.util.List;

public interface INode {

	SemanticType getSemanticType();

	void setSemanticType(SemanticType semanticType);

	SemanticType getInitialSemanticType();

	void setRecognizedStructureId(Long id);

	Long getRecognizedStructureId();

	Double getCorrectSemanticScore();

	void setCorrectSemanticScore(Double correctSemanticScore);

	Integer getPageNumber();

	void setPageNumber(Integer pageNumber);

	Integer getLastPageNumber();

	void setLastPageNumber(Integer lastPageNumber);

	double getLeftX();

	double getRightX();

	double getBottomY();

	double getTopY();

	BoundingBox getBoundingBox();

	void setBoundingBox(BoundingBox boundingBox);

	List<INode> getChildren();

	void setParent(INode node);

	INode getParent();

	INode getNextNeighbor();

	INode getPreviousNeighbor();

	INode getNextNode();

	void setIndex(Integer index);

	Integer getIndex();

	boolean isRoot();

	void addChild(INode child);

	boolean isLeaf();

	public NodeInfo getNodeInfo();

	public int getDepth();

	public void setDepth(int depth);

	public boolean getHasLowestDepthError();

	public void setHasLowestDepthError();
}
