/**
 * This file is part of veraPDF wcag algorithms, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF wcag algorithms is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF wcag algorithms as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF wcag algorithms as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.wcag.algorithms.entities;

import org.verapdf.wcag.algorithms.entities.content.ImageChunk;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;

public class SemanticImageNode extends SemanticNode {

	protected final ImageChunk image;

    public SemanticImageNode(SemanticImageNode imageNode) {
        super(imageNode.getBoundingBox());
        this.image = imageNode.getImage();
        setSemanticType(SemanticType.FIGURE);
    }

    public SemanticImageNode(ImageChunk image) {
        super(image.getBoundingBox());
        this.image = image;
        setSemanticType(SemanticType.FIGURE);
    }

	public ImageChunk getImage() {
		return image;
	}

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof SemanticImageNode)) {
            return false;
        }
        SemanticImageNode that = (SemanticImageNode) o;
        return this.image.equals(that.getImage());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return 31 * result + image.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("SemanticImageNode{");
        result.append("pageNumber=");
        result.append(getBoundingBox().getPageNumber());
        result.append(", boundingBox=");
        result.append(getBoundingBox());
        result.append("}");
        return result.toString();
    }
}
