/**
 * This file is part of veraPDF wcag algorithms, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF wcag algorithms is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF wcag algorithms as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF wcag algorithms as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.wcag.algorithms.entities.lists;

public class ListInterval {
	private final int start;
	private final int end;
	public Integer numberOfColumns;

	public ListInterval(int start, int end) {
		this.start = start;
		this.end = end;
	}

	public ListInterval(int start, int end, Integer numberOfColumns) {
		this.start = start;
		this.end = end;
		this.numberOfColumns = numberOfColumns;
	}

	public int getStart() {
		return start;
	}

	public int getEnd() {
		return end;
	}

	public Integer getNumberOfColumns() {
		return numberOfColumns;
	}

	public int getNumberOfListItems() {
		return end - start + 1;
	}

	@Override
	public int hashCode() {
		return 31 * end + start;
	}

	@Override
	public boolean equals(Object o) {
		if (!(o instanceof ListInterval)) {
			return false;
		}
		ListInterval that = (ListInterval) o;
		return this.start == that.start && this.end == that.end;
	}

	public boolean contains(ListInterval second) {
		return this.start <= second.start && this.end >= second.end;
	}
}
