/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.IDocument;
import org.verapdf.wcag.algorithms.entities.IPage;
import org.verapdf.wcag.algorithms.entities.ITree;
import org.verapdf.wcag.algorithms.entities.content.IChunk;

public class Document
implements IDocument {
    private ITree tree;
    private List<IPage> pages;

    public Document(ITree tree) {
        this.tree = tree;
        this.pages = new LinkedList<IPage>();
    }

    @Override
    public ITree getTree() {
        return this.tree;
    }

    @Override
    public List<IChunk> getArtifacts(Integer pageNumber) {
        if (pageNumber < this.pages.size()) {
            return this.pages.get(pageNumber).getArtifacts();
        }
        return Collections.emptyList();
    }

    @Override
    public List<IPage> getPages() {
        return this.pages;
    }

    @Override
    public IPage getPage(Integer pageNumber) {
        if (pageNumber < this.pages.size()) {
            return this.pages.get(pageNumber);
        }
        return null;
    }

    @Override
    public List<IChunk> getArtifacts() {
        ArrayList<IChunk> artifacts = new ArrayList<IChunk>();
        for (IPage page : this.pages) {
            artifacts.addAll(page.getArtifacts());
        }
        return artifacts;
    }
}

