/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities;

import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;

public class SemanticCaption
extends SemanticTextNode {
    public SemanticCaption(SemanticCaption caption) {
        super(caption);
    }

    public SemanticCaption(SemanticTextNode textNode) {
        super(textNode);
    }

    public SemanticCaption() {
        this.setSemanticType(SemanticType.CAPTION);
    }

    public SemanticCaption(SemanticType initialSemanticType) {
        super(initialSemanticType);
        this.setSemanticType(SemanticType.CAPTION);
    }

    public SemanticCaption(BoundingBox bbox) {
        super(bbox);
    }

    public SemanticCaption(BoundingBox bbox, SemanticType initialSemanticType) {
        super(bbox, initialSemanticType);
        this.setSemanticType(SemanticType.CAPTION);
    }

    public SemanticCaption(TextChunk textChunk) {
        this.setSemanticType(SemanticType.CAPTION);
        this.add(new TextLine(textChunk));
    }

    public SemanticCaption(TextChunk textChunk, SemanticType initialSemanticType) {
        this(initialSemanticType);
        this.add(new TextLine(textChunk));
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        return o instanceof SemanticCaption;
    }
}

