/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.NodeInfo;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.MultiBoundingBox;

public abstract class SemanticNode
implements INode {
    private Double correctSemanticScore;
    private BoundingBox boundingBox;
    private SemanticType semanticType;
    private Long recognizedStructureId = null;
    private Integer index = null;
    private INode parent = null;
    private final List<INode> children;
    private final SemanticType initialSemanticType;
    private int depth;
    private boolean hasLowestDepthError = false;
    public NodeInfo nodeInfo = new NodeInfo();

    public SemanticNode() {
        this.boundingBox = new BoundingBox();
        this.children = new ArrayList<INode>();
        this.initialSemanticType = null;
    }

    public SemanticNode(SemanticType initialSemanticType) {
        this.boundingBox = new BoundingBox();
        this.children = new ArrayList<INode>();
        this.initialSemanticType = initialSemanticType;
    }

    public SemanticNode(BoundingBox bbox, SemanticType initialSemanticType, SemanticType semanticType) {
        this(bbox, initialSemanticType);
        this.semanticType = semanticType;
    }

    public SemanticNode(BoundingBox bbox, SemanticType initialSemanticType) {
        this.children = new ArrayList<INode>();
        this.boundingBox = new MultiBoundingBox(bbox);
        this.initialSemanticType = initialSemanticType;
    }

    public SemanticNode(BoundingBox bbox) {
        this.children = new ArrayList<INode>();
        this.boundingBox = new MultiBoundingBox(bbox);
        this.initialSemanticType = null;
    }

    @Override
    public Double getCorrectSemanticScore() {
        return this.correctSemanticScore;
    }

    @Override
    public void setCorrectSemanticScore(Double correctSemanticScore) {
        this.correctSemanticScore = correctSemanticScore;
    }

    @Override
    public Long getRecognizedStructureId() {
        return this.recognizedStructureId;
    }

    @Override
    public void setRecognizedStructureId(Long id) {
        this.recognizedStructureId = id;
    }

    @Override
    public Integer getPageNumber() {
        return this.boundingBox.getPageNumber();
    }

    @Override
    public void setPageNumber(Integer pageNumber) {
        this.boundingBox.setPageNumber(pageNumber);
    }

    @Override
    public Integer getLastPageNumber() {
        return this.boundingBox.getLastPageNumber();
    }

    @Override
    public void setLastPageNumber(Integer lastPageNumber) {
        this.boundingBox.setLastPageNumber(lastPageNumber);
    }

    @Override
    public double getLeftX() {
        return this.boundingBox.getLeftX();
    }

    @Override
    public double getBottomY() {
        return this.boundingBox.getBottomY();
    }

    @Override
    public double getRightX() {
        return this.boundingBox.getRightX();
    }

    @Override
    public double getTopY() {
        return this.boundingBox.getTopY();
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public void setBoundingBox(BoundingBox bbox) {
        this.boundingBox = bbox instanceof MultiBoundingBox ? new MultiBoundingBox(bbox) : new BoundingBox(bbox);
    }

    @Override
    public SemanticType getSemanticType() {
        return this.semanticType;
    }

    @Override
    public void setSemanticType(SemanticType semanticType) {
        this.semanticType = semanticType;
    }

    @Override
    public SemanticType getInitialSemanticType() {
        return this.initialSemanticType;
    }

    @Override
    public List<INode> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(INode child) {
        this.children.add(child);
    }

    @Override
    public void setParent(INode node) {
        this.parent = node;
    }

    @Override
    public INode getParent() {
        return this.parent;
    }

    @Override
    public Integer getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Override
    public INode getNextNeighbor() {
        if (this.parent != null && this.index != null && this.index + 1 < this.parent.getChildren().size()) {
            return this.parent.getChildren().get(this.index + 1);
        }
        return null;
    }

    @Override
    public INode getPreviousNeighbor() {
        if (this.parent != null && this.index != null && this.index > 0) {
            return this.parent.getChildren().get(this.index - 1);
        }
        return null;
    }

    @Override
    public INode getNextNode() {
        INode nextNeighbor = this.getNextNeighbor();
        if (nextNeighbor != null) {
            return nextNeighbor;
        }
        return this.parent != null ? this.parent.getNextNode() : null;
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public void setHasLowestDepthError() {
        this.hasLowestDepthError = true;
    }

    @Override
    public boolean getHasLowestDepthError() {
        return this.hasLowestDepthError;
    }

    @Override
    public void setDepth(int depth) {
        this.depth = depth;
    }

    @Override
    public NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public int hashCode() {
        return Objects.hashCode(this.boundingBox);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemanticNode that = (SemanticNode)o;
        return that.boundingBox.equals(this.boundingBox);
    }

    public String toString() {
        return "SemanticNode{initialSemanticType=" + (Object)((Object)this.initialSemanticType) + ", correctSemanticScore=" + this.correctSemanticScore + ", pageNumber=" + this.boundingBox.getPageNumber() + ", boundingBox=" + this.boundingBox + ", semanticType=" + (Object)((Object)this.semanticType) + ", children=" + this.children + '}';
    }
}

