/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.content;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.verapdf.wcag.algorithms.entities.IDocument;
import org.verapdf.wcag.algorithms.entities.content.IChunk;
import org.verapdf.wcag.algorithms.entities.content.LineChunk;

public class LinesCollection {
    private final Map<Integer, SortedSet<LineChunk>> horizontalLines = new HashMap<Integer, SortedSet<LineChunk>>();
    private final Map<Integer, SortedSet<LineChunk>> verticalLines = new HashMap<Integer, SortedSet<LineChunk>>();
    private final Map<Integer, SortedSet<LineChunk>> squares = new HashMap<Integer, SortedSet<LineChunk>>();
    private final IDocument document;

    public LinesCollection(IDocument document) {
        this.document = document;
    }

    public SortedSet<LineChunk> getHorizontalLines(Integer pageNumber) {
        SortedSet<LineChunk> horizontalLines = this.horizontalLines.get(pageNumber);
        if (horizontalLines == null) {
            this.parseLines(pageNumber);
            horizontalLines = this.horizontalLines.get(pageNumber);
        }
        return horizontalLines;
    }

    private void parseLines(Integer pageNumber) {
        TreeSet<LineChunk> horizontalLines = new TreeSet<LineChunk>(new LineChunk.HorizontalLineComparator());
        TreeSet<LineChunk> verticalLines = new TreeSet<LineChunk>(new LineChunk.VerticalLineComparator());
        TreeSet<LineChunk> squares = new TreeSet<LineChunk>(new LineChunk.VerticalLineComparator());
        for (IChunk chunk : this.document.getArtifacts(pageNumber)) {
            if (!(chunk instanceof LineChunk)) continue;
            LineChunk lineChunk = (LineChunk)chunk;
            if (lineChunk.isHorizontalLine()) {
                horizontalLines.add(lineChunk);
                continue;
            }
            if (lineChunk.isVerticalLine()) {
                verticalLines.add(lineChunk);
                continue;
            }
            if (!lineChunk.isSquare()) continue;
            squares.add(lineChunk);
        }
        this.horizontalLines.put(pageNumber, horizontalLines);
        this.verticalLines.put(pageNumber, verticalLines);
        this.squares.put(pageNumber, squares);
    }

    public SortedSet<LineChunk> getVerticalLines(Integer pageNumber) {
        SortedSet<LineChunk> verticalLines = this.verticalLines.get(pageNumber);
        if (verticalLines == null) {
            this.parseLines(pageNumber);
            verticalLines = this.verticalLines.get(pageNumber);
        }
        return verticalLines;
    }

    public SortedSet<LineChunk> getSquares(Integer pageNumber) {
        SortedSet<LineChunk> squares = this.squares.get(pageNumber);
        if (squares == null) {
            this.parseLines(pageNumber);
            squares = this.squares.get(pageNumber);
        }
        return squares;
    }
}

