/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.tables;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.content.TextInfoChunk;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.MultiBoundingBox;
import org.verapdf.wcag.algorithms.entities.tables.TableCell;

public class TableRow
extends TextInfoChunk {
    private List<TableCell> cells = new ArrayList<TableCell>();
    private SemanticType semanticType = null;

    public TableRow() {
        super(new MultiBoundingBox());
    }

    public TableRow(SemanticType semanticType) {
        this();
        this.semanticType = semanticType;
    }

    public void setSemanticType(SemanticType semanticType) {
        this.semanticType = semanticType;
    }

    public SemanticType getSemanticType() {
        return this.semanticType;
    }

    public void add(TableCell cell) {
        this.cells.add(cell);
        super.add(cell);
    }

    public List<TableCell> getCells() {
        return this.cells;
    }

    public int getNumberOfCellsWithContent() {
        int numberOfCellsWithContent = 0;
        for (TableCell cell : this.cells) {
            if (cell.getContent().isEmpty()) continue;
            ++numberOfCellsWithContent;
        }
        return numberOfCellsWithContent;
    }

    public void merge(TableRow other) {
        List<TableCell> otherCells = other.getCells();
        for (int i = 0; i < otherCells.size(); ++i) {
            if (i < this.cells.size()) {
                this.cells.get(i).merge(otherCells.get(i));
                continue;
            }
            this.cells.add(otherCells.get(i));
        }
        super.add(other);
    }
}

