/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.SemanticList;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.InfoChunk;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.lists.ListInterval;
import org.verapdf.wcag.algorithms.entities.lists.ListIntervalsCollection;
import org.verapdf.wcag.algorithms.entities.tables.Table;
import org.verapdf.wcag.algorithms.entities.tables.TableCell;
import org.verapdf.wcag.algorithms.entities.tables.TableRow;
import org.verapdf.wcag.algorithms.entities.tables.TableToken;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ListLabelsUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;

public class ListUtils {
    public static final double LIST_LABEL_HEIGHT_EPSILON = 2.5;
    private static final Set<SemanticType> listSemanticTypes = new HashSet<SemanticType>(Arrays.asList(SemanticType.LIST, SemanticType.LIST_ITEM, SemanticType.LIST_LABEL, SemanticType.LIST_BODY));

    public static boolean isListNode(INode node) {
        return listSemanticTypes.contains((Object)node.getSemanticType());
    }

    public static boolean isInitialListNode(INode node) {
        return listSemanticTypes.contains((Object)node.getInitialSemanticType());
    }

    public static boolean isList(Table table) {
        ArrayList<String> textLabels = new ArrayList<String>(table.getRows().size());
        ArrayList<BoundingBox> imageLabels = new ArrayList<BoundingBox>(table.getRows().size());
        for (TableRow row : table.getRows()) {
            List<TableCell> cells = row.getCells();
            if (cells.size() != 2) {
                return false;
            }
            TableCell cell = cells.get(0);
            if (cell.isTextCell()) {
                textLabels.add(cell.getString());
                continue;
            }
            if (cell.getContent().size() == 1 && cell.getContent().get(0).getType() == TableToken.TableTokenType.IMAGE) {
                imageLabels.add(cell.getContent().get(0).getBoundingBox());
                continue;
            }
            return false;
        }
        if (!imageLabels.isEmpty() && !textLabels.isEmpty()) {
            return false;
        }
        return imageLabels.isEmpty() ? ListLabelsUtils.isListLabels(textLabels) : ListUtils.isListImageLabels(imageLabels);
    }

    public static boolean isListImageLabels(List<BoundingBox> listLabels) {
        if (listLabels.size() < 2) {
            return false;
        }
        BoundingBox firstLabel = listLabels.get(0);
        double firstLabelHeight = firstLabel.getHeight();
        for (int i = 1; i < listLabels.size(); ++i) {
            if (NodeUtils.areCloseNumbers(listLabels.get(i).getLeftX(), listLabels.get(0).getLeftX()) && NodeUtils.areCloseNumbers(listLabels.get(i).getRightX(), listLabels.get(0).getRightX()) && NodeUtils.areCloseNumbers(listLabels.get(i).getHeight(), firstLabelHeight)) continue;
            return false;
        }
        return true;
    }

    public static void updateTreeWithRecognizedLists(INode node, List<INode> children, Set<ListInterval> listIntervals) {
        for (ListInterval listInterval : listIntervals) {
            ListUtils.updateTreeWithRecognizedList(node, children, listInterval);
        }
    }

    public static void updateTreeWithRecognizedList(INode node, List<INode> children, ListInterval listInterval) {
        double probability;
        Long listId = Table.getNextTableListId();
        for (int i = listInterval.getStart(); i <= listInterval.getEnd(); ++i) {
            ListUtils.updateTreeWithRecognizedListItem(children.get(i), listId);
        }
        if (node.getRecognizedStructureId() == null && (probability = (double)listInterval.getNumberOfListItems() / (double)node.getChildren().size()) >= 0.75) {
            INode accumulatedNode = StaticContainers.getAccumulatedNodeMapper().get(node);
            StaticContainers.getAccumulatedNodeMapper().updateNode(node, new SemanticList((SemanticTextNode)accumulatedNode, listInterval), probability, SemanticType.LIST);
            node.setRecognizedStructureId(listId);
        }
    }

    public static void updateTreeWithRecognizedListItem(INode item, Long listId) {
        item.setSemanticType(SemanticType.LIST_ITEM);
        item.setCorrectSemanticScore(1.0);
        item.setRecognizedStructureId(listId);
        List<INode> children = item.getChildren();
        if (children.size() == 1) {
            INode child = children.get(0);
            child.setSemanticType(SemanticType.LIST_BODY);
            child.setCorrectSemanticScore(1.0);
            child.setRecognizedStructureId(listId);
        } else if (children.size() > 1) {
            INode child = children.get(0);
            child.setSemanticType(SemanticType.LIST_LABEL);
            child.setRecognizedStructureId(listId);
            for (int i = 1; i < children.size(); ++i) {
                child = children.get(i);
                child.setSemanticType(SemanticType.LIST_BODY);
                child.setCorrectSemanticScore(1.0);
                child.setRecognizedStructureId(listId);
            }
        }
    }

    public static Set<ListInterval> getChildrenListIntervals(Set<ListInterval> listIntervals, List<INode> children, List<? extends InfoChunk> childrenFirstLines) {
        ListIntervalsCollection listIntervalsCollection = new ListIntervalsCollection();
        for (ListInterval listInterval : listIntervals) {
            INode accumulatedChild = StaticContainers.getAccumulatedNodeMapper().get(children.get(listInterval.getStart()));
            double right = accumulatedChild.getRightX();
            int start = listInterval.getStart();
            int numberOfColumns = ListUtils.getInitialListColumnsNumber(accumulatedChild);
            for (int i = listInterval.getStart() + 1; i <= listInterval.getEnd(); ++i) {
                int lastChildNumberOFColumns = 0;
                if (accumulatedChild instanceof SemanticTextNode) {
                    SemanticTextNode textNode = (SemanticTextNode)accumulatedChild;
                    if (textNode.getColumnsNumber() > 1) {
                        right = textNode.getPenultColumn().getRightX();
                    }
                    lastChildNumberOFColumns = Math.max(textNode.getColumnsNumber() - 2, 0);
                }
                InfoChunk line1 = childrenFirstLines.get(i - 1);
                InfoChunk line2 = childrenFirstLines.get(i);
                accumulatedChild = StaticContainers.getAccumulatedNodeMapper().get(children.get(i));
                if (line1.getPageNumber() + 1 < line2.getPageNumber()) {
                    if (start < i - 1) {
                        listIntervalsCollection.put(new ListInterval(start, i - 1, numberOfColumns));
                    }
                    start = i;
                    right = -1.7976931348623157E308;
                    numberOfColumns = ListUtils.getInitialListColumnsNumber(accumulatedChild);
                    continue;
                }
                if (Objects.equals(line1.getPageNumber(), line2.getPageNumber())) {
                    if (!ListUtils.isOneColumn(line1, line2) && right >= accumulatedChild.getLeftX()) {
                        if (start < i - 1) {
                            listIntervalsCollection.put(new ListInterval(start, i - 1, numberOfColumns));
                        }
                        start = i;
                        right = -1.7976931348623157E308;
                        numberOfColumns = ListUtils.getInitialListColumnsNumber(accumulatedChild);
                    }
                    if (!ListUtils.isOneColumn(line1, line2)) {
                        numberOfColumns += lastChildNumberOFColumns + 1;
                    }
                    right = Math.max(right, accumulatedChild.getRightX());
                    continue;
                }
                ++numberOfColumns;
                right = accumulatedChild.getRightX();
            }
            if (start >= listInterval.getEnd()) continue;
            listIntervalsCollection.put(new ListInterval(start, listInterval.getEnd(), numberOfColumns));
        }
        return listIntervalsCollection.getSet();
    }

    private static int getInitialListColumnsNumber(INode node) {
        return node instanceof SemanticTextNode ? Math.max(((SemanticTextNode)node).getColumnsNumber() - 1, 1) : 1;
    }

    private static boolean isOneColumn(InfoChunk line1, InfoChunk line2) {
        return NodeUtils.areCloseNumbers(line1.getLeftX(), line2.getLeftX(), line1.getBoundingBox().getHeight() / 2.0);
    }
}

