/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.verapdf.wcag.algorithms.entities.IDocument;
import org.verapdf.wcag.algorithms.entities.ITree;
import org.verapdf.wcag.algorithms.entities.enums.TextType;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.ContrastRatioConsumer;

public class ContrastRatioChecker {
    public void checkSemanticTree(ITree tree, String pdfName) {
        ContrastRatioConsumer v = new ContrastRatioConsumer(pdfName);
        tree.forEach(v);
    }

    public void checkDocument(IDocument document, String pdfName) {
        ContrastRatioConsumer v = new ContrastRatioConsumer(pdfName);
        if (document.getTree() != null) {
            document.getTree().forEach(v);
        }
    }

    public double getContrastRatio(double first, double second) {
        double l1 = Math.max(first, second);
        double l2 = Math.min(first, second);
        return (l1 + 0.05) / (l2 + 0.05);
    }

    boolean isTextContrastRatioCompliant(BufferedImage sourceTextImage, TextType type, boolean isHighVisibility) {
        List<DataPoint> localMaximums = this.findLocalMaximums(this.getLuminosityPresenceList(sourceTextImage));
        double[] contrastColors = this.get2MostPresentElements(localMaximums);
        double colorContrast = this.getContrastRatio(contrastColors[0], contrastColors[1]);
        return this.isContrastRatioCompliant(colorContrast, type, isHighVisibility);
    }

    private boolean isContrastRatioCompliant(double colorContrast, TextType type, boolean isHighVisibility) {
        switch (type) {
            case REGULAR: {
                return isHighVisibility ? colorContrast >= 7.0 : colorContrast >= 4.5;
            }
            case LARGE: {
                return isHighVisibility ? colorContrast >= 4.5 : colorContrast >= 3.0;
            }
            case LOGO: {
                return true;
            }
        }
        return false;
    }

    private double relativeLuminosity(Color color) {
        double normalizedRed = this.normalizeColorComponent(color.getRed());
        double normalizeGreen = this.normalizeColorComponent(color.getGreen());
        double normalizeBlue = this.normalizeColorComponent(color.getBlue());
        return 0.2126 * normalizedRed + 0.7152 * normalizeGreen + 0.0722 * normalizeBlue;
    }

    private double normalizeColorComponent(int colorComponent) {
        double doubleColorComponent = (double)colorComponent / 255.0;
        return doubleColorComponent < 0.03928 ? doubleColorComponent / 12.92 : Math.pow((doubleColorComponent + 0.055) / 1.055, 2.4);
    }

    private List<DataPoint> getLuminosityPresenceList(BufferedImage bim) {
        int width = bim.getWidth();
        int height = bim.getHeight();
        HashMap<Color, DataPoint> colorMap = new HashMap<Color, DataPoint>();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int rgb = bim.getRGB(i, j);
                int alpha = rgb >> 24 & 0xFF;
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                Color color = new Color(red, green, blue);
                if (colorMap.containsKey(color)) {
                    ((DataPoint)colorMap.get(color)).totalOccurrence++;
                    continue;
                }
                double relativeLuminosity = this.relativeLuminosity(color);
                colorMap.put(color, new DataPoint(relativeLuminosity));
            }
        }
        return new ArrayList<DataPoint>(new TreeSet(colorMap.values()));
    }

    private List<DataPoint> findLocalMaximums(List<DataPoint> source) {
        ArrayList<DataPoint> localMaximums = new ArrayList<DataPoint>();
        boolean isPreviousLessThanCurrent = true;
        for (int i = 0; i < source.size() - 1; ++i) {
            boolean isNextLessThanCurrent;
            boolean bl = isNextLessThanCurrent = source.get(i).totalOccurrence > source.get(i + 1).totalOccurrence;
            if (isNextLessThanCurrent && isPreviousLessThanCurrent) {
                localMaximums.add(source.get(i));
            }
            isPreviousLessThanCurrent = !isNextLessThanCurrent;
        }
        if (isPreviousLessThanCurrent) {
            localMaximums.add(source.get(source.size() - 1));
        }
        return localMaximums;
    }

    private double[] get2MostPresentElements(List<DataPoint> source) {
        double absoluteMaxPresent = -1.0;
        double secondMaxPresent = -1.0;
        int max = 0;
        int secondMax = 0;
        for (DataPoint dataPoint : source) {
            if (dataPoint.totalOccurrence >= max) {
                secondMaxPresent = absoluteMaxPresent;
                secondMax = max;
                absoluteMaxPresent = dataPoint.value;
                max = dataPoint.totalOccurrence;
                continue;
            }
            if (dataPoint.totalOccurrence < secondMax) continue;
            secondMax = dataPoint.totalOccurrence;
            secondMaxPresent = dataPoint.value;
        }
        return new double[]{absoluteMaxPresent, secondMaxPresent};
    }

    static class DataPoint
    implements Comparable<DataPoint> {
        private double value;
        private int totalOccurrence;

        public DataPoint() {
        }

        public DataPoint(double value) {
            this.value = value;
            this.totalOccurrence = 1;
        }

        public double getValue() {
            return this.value;
        }

        public int getTotalOccurrence() {
            return this.totalOccurrence;
        }

        public void setTotalOccurrence(int totalOccurrence) {
            this.totalOccurrence = totalOccurrence;
        }

        @Override
        public int compareTo(DataPoint o) {
            return Double.compare(this.value, o.value);
        }
    }
}

