/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.lists.ListInterval;
import org.verapdf.wcag.algorithms.entities.lists.info.ListItemTextInfo;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection.ListLabelsDetectionAlgorithm;

public abstract class LettersListLabelsDetectionAlgorithm
extends ListLabelsDetectionAlgorithm {
    @Override
    public boolean isListLabels(List<String> labels, int commonStartLength, int commonEndLength) {
        boolean isUpperCase;
        if (!labels.get(0).substring(commonStartLength, labels.get(0).length() - commonEndLength).matches(this.getRegex())) {
            return false;
        }
        int startLength = this.getNotRegexStartLength(labels.get(0), commonStartLength);
        int endLength = this.getNotRegexEndLength(labels.get(0), commonEndLength);
        String substring = labels.get(0).substring(startLength, labels.get(0).length() - endLength);
        if (substring.matches(this.getLowerCaseRegex())) {
            isUpperCase = false;
        } else if (substring.matches(this.getUpperCaseRegex())) {
            isUpperCase = true;
        } else {
            return false;
        }
        Integer number = this.getNumberFromString(substring.toUpperCase());
        if (number == null) {
            return false;
        }
        if (!substring.equalsIgnoreCase(this.getStringFromNumber(number))) {
            return false;
        }
        for (int i = 1; i < labels.size(); ++i) {
            substring = labels.get(i).substring(startLength, labels.get(i).length() - endLength);
            if (!(substring.matches(this.getLowerCaseRegex()) && !isUpperCase || substring.matches(this.getUpperCaseRegex()) && isUpperCase)) {
                return false;
            }
            Integer nextNumber = this.getNumberFromString(substring.toUpperCase());
            if (nextNumber == null) {
                return false;
            }
            if (substring.equalsIgnoreCase(this.getStringFromNumber(nextNumber)) && nextNumber.equals(number = Integer.valueOf(number + 1))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<ListInterval> getItemsIntervals(List<ListItemTextInfo> itemsInfo) {
        HashSet<ListInterval> listIntervals = new HashSet<ListInterval>();
        Integer number = null;
        int start = 0;
        String prefix = null;
        boolean isUpperCase = false;
        ListInterval interval = new ListInterval();
        for (int i = 0; i < itemsInfo.size(); ++i) {
            int regexStartLength;
            String substring;
            String suffix;
            int commonLength;
            ListItemTextInfo itemInfo = itemsInfo.get(i);
            String item = itemInfo.getListItem();
            if (number != null) {
                Integer n = number;
                number = number + 1;
                String s = this.getStringFromNumber(number);
                if (!(item.toUpperCase().startsWith(s, start) && item.startsWith(prefix) && !this.isCharMatchRegex(item, start + s.length()) && !this.isBadItem(itemInfo, item, s, start) && (item.substring(start, start + s.length()).matches(this.getLowerCaseRegex()) && !isUpperCase || item.substring(start, start + s.length()).matches(this.getUpperCaseRegex()) && isUpperCase))) {
                    if (SemanticType.LIST == itemInfo.getSemanticType()) {
                        interval.getListsIndexes().add(itemInfo.getIndex());
                        Integer n2 = number;
                        number = number - 1;
                        continue;
                    }
                    if (interval.getNumberOfListItems() > 1) {
                        listIntervals.add(interval);
                    }
                    number = null;
                } else {
                    interval.getListItemsInfos().add(itemInfo);
                }
            }
            if (number != null || i == itemsInfo.size() - 1 || !this.checkPrefixAndSuffix(prefix = item.substring(0, start = this.getNotRegexStartLength(item, commonLength = LettersListLabelsDetectionAlgorithm.getCommonStartLength(item, itemsInfo.get(i + 1).getListItem()))), suffix = (substring = item.substring(start)).substring(regexStartLength = this.getRegexStartLength(substring))).booleanValue()) continue;
            if ((substring = substring.substring(0, regexStartLength)).matches(this.getLowerCaseRegex())) {
                isUpperCase = false;
            } else {
                if (!substring.matches(this.getUpperCaseRegex())) continue;
                isUpperCase = true;
            }
            number = this.getNumberFromString(substring.toUpperCase());
            if (number == null || this.isBadItem(itemInfo, item, substring, start)) continue;
            if (!substring.toUpperCase().startsWith(this.getStringFromNumber(number))) {
                number = null;
                continue;
            }
            interval = new ListInterval();
            interval.getListItemsInfos().add(itemInfo);
        }
        if (number != null && interval.getNumberOfListItems() > 1) {
            listIntervals.add(interval);
        }
        return listIntervals;
    }

    private boolean isBadItem(ListItemTextInfo listItem, String item, String s, int start) {
        return item.length() == start + s.length() && listItem.hasOneLine();
    }

    protected abstract String getLowerCaseRegex();

    protected abstract String getUpperCaseRegex();

    protected boolean isCharMatchRegex(String s, int index) {
        return LettersListLabelsDetectionAlgorithm.isCharMatchRegex(s, index, this.getRegex());
    }

    private static boolean isCharMatchRegex(String s, int index, String regex) {
        if (s.length() <= index) {
            return false;
        }
        return s.substring(index, index + 1).matches(regex);
    }
}

