/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection;

import java.util.ArrayList;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection.Roman;

public class RomanNumber {
    private static final int[] numbers = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static final String[] letters = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    private final int arabicNumber;

    public RomanNumber(String s) throws NumberFormatException {
        if (!s.matches("[MDCLXVImdclxvi]*") || s.isEmpty()) {
            throw new NumberFormatException();
        }
        ArrayList<Roman> romans = new ArrayList<Roman>();
        for (int i = 0; i < s.length(); ++i) {
            romans.add(Roman.valueOf(s.substring(i, i + 1)));
        }
        int value = 0;
        while (!romans.isEmpty()) {
            Roman current = (Roman)((Object)romans.remove(0));
            if (!romans.isEmpty() && current.isLess((Roman)((Object)romans.get(0)))) {
                value += current.toInt((Roman)((Object)romans.remove(0)));
                continue;
            }
            value += current.toInt();
        }
        this.arabicNumber = value;
    }

    public RomanNumber(int arabicNumber) {
        this.arabicNumber = arabicNumber;
    }

    public int getArabicNumber() {
        return this.arabicNumber;
    }

    public String toString() {
        StringBuilder roman = new StringBuilder();
        int N = this.arabicNumber;
        for (int i = 0; i < numbers.length; ++i) {
            while (N >= numbers[i]) {
                roman.append(letters[i]);
                N -= numbers[i];
            }
        }
        return roman.toString();
    }
}

