/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.consumers;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.ITree;
import org.verapdf.wcag.algorithms.entities.RepeatedCharacters;
import org.verapdf.wcag.algorithms.entities.SemanticAnnot;
import org.verapdf.wcag.algorithms.entities.SemanticSpan;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextColumn;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.MultiBoundingBox;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.WCAGConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.HeadingUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ListUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TOCUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TableUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TextChunkUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.WCAGProgressStatus;

public class SemanticDocumentPostprocessingConsumer
extends WCAGConsumer {
    public void runPostprocessingChecks(ITree tree) {
        this.updateBoundingBoxes(tree);
        this.checkForTitle(tree);
        this.checkForRepeatedCharacters(tree);
        this.setLowestDepthErrorFlag(tree);
        this.updateIDs(tree);
    }

    public void updateBoundingBoxes(ITree tree) {
        for (INode node : tree) {
            MultiBoundingBox boundingBox = new MultiBoundingBox();
            for (INode child : node.getChildren()) {
                if (child instanceof SemanticAnnot) continue;
                boundingBox.union(child.getBoundingBox());
            }
            if (node.getChildren().isEmpty()) continue;
            node.setBoundingBox(boundingBox);
        }
    }

    public void setLowestDepthErrorFlag(ITree tree) {
        for (INode child : tree.getRoot().getChildren()) {
            this.setLowestDepthErrorFlag(child);
        }
    }

    public void checkForTitle(ITree tree) {
        for (INode node : tree) {
            if (this.checkNode(node)) break;
        }
    }

    public void checkForRepeatedCharacters(ITree tree) {
        ArrayList<TextChunk> chunks = new ArrayList<TextChunk>();
        this.checkForRepeatedCharacters(tree.getRoot(), chunks);
        this.checkRepeatedAndAdd(chunks);
    }

    public void checkForRepeatedCharacters(INode node, List<TextChunk> chunks) {
        for (INode child : node.getChildren()) {
            if (child.getInitialSemanticType() != SemanticType.FIGURE && child.getInitialSemanticType() != SemanticType.CODE) {
                this.checkForRepeatedCharacters(child, chunks);
            }
            if (!(child instanceof SemanticSpan)) continue;
            for (TextColumn textColumn : ((SemanticSpan)child).getColumns()) {
                for (TextLine textLine : textColumn.getLines()) {
                    for (TextChunk textChunk : textLine.getTextChunks()) {
                        if (textChunk.getValue().isEmpty()) continue;
                        if (!chunks.isEmpty() && this.areChunksChained(chunks.get(chunks.size() - 1).getValue(), textChunk)) {
                            chunks.add(textChunk);
                            continue;
                        }
                        this.checkRepeatedAndAdd(chunks);
                        chunks.clear();
                        chunks.add(textChunk);
                    }
                }
            }
        }
    }

    private boolean areChunksChained(String previousValue, TextChunk secondTextChunk) {
        char firstChar = previousValue.charAt(previousValue.length() - 1);
        char secondChar = secondTextChunk.getValue().charAt(0);
        if (TextChunkUtils.isWhiteSpaceChar(firstChar) && TextChunkUtils.isWhiteSpaceChar(secondChar)) {
            return true;
        }
        return firstChar == secondChar;
    }

    private boolean checkNode(INode node) {
        if (this.isTextNode(node)) {
            if (this.isTitle(node)) {
                node.setSemanticType(SemanticType.TITLE);
                return true;
            }
            for (INode parent = node.getParent(); parent != null && StaticContainers.getAccumulatedNodeMapper().get(parent) instanceof SemanticTextNode; parent = parent.getParent()) {
                if (!this.isTitle(parent)) continue;
                parent.setSemanticType(SemanticType.TITLE);
                break;
            }
            return true;
        }
        return false;
    }

    private void setLowestDepthErrorFlag(INode node) {
        if ((TableUtils.isTableNode(node) || TableUtils.isInitialTableNode(node)) && node.getSemanticType() != node.getInitialSemanticType()) {
            node.setHasLowestDepthError();
            return;
        }
        if ((ListUtils.isDetectedListNode(node) || ListUtils.isInitialListNode(node)) && node.getSemanticType() != node.getInitialSemanticType()) {
            node.setHasLowestDepthError();
            return;
        }
        if ((TOCUtils.isTOCNode(node) || TOCUtils.isInitialTOCNode(node)) && node.getSemanticType() != node.getInitialSemanticType()) {
            node.setHasLowestDepthError();
            return;
        }
        for (INode child : node.getChildren()) {
            this.setLowestDepthErrorFlag(child);
        }
    }

    private boolean isTextNode(INode node) {
        INode accumulatedNode = StaticContainers.getAccumulatedNodeMapper().get(node);
        return accumulatedNode instanceof SemanticTextNode && !((SemanticTextNode)accumulatedNode).isSpaceNode() && !node.getChildren().isEmpty();
    }

    private boolean isTitle(INode node) {
        return HeadingUtils.isDetectedHeadingNode(node) && !HeadingUtils.isInitialHeadingNode(node);
    }

    private void checkRepeatedAndAdd(List<TextChunk> textChunks) {
        if (textChunks.isEmpty()) {
            return;
        }
        int length = 0;
        boolean isLastCharacterWhiteSpace = false;
        Character lastCharacter = null;
        MultiBoundingBox resultBox = new MultiBoundingBox();
        for (TextChunk textChunk : textChunks) {
            char[] characters = textChunk.getValue().toCharArray();
            lastCharacter = Character.valueOf(characters[0]);
            isLastCharacterWhiteSpace = TextChunkUtils.isWhiteSpaceChar(lastCharacter.charValue());
            int start = 0;
            ++length;
            for (int charIndex = 1; charIndex < characters.length; ++charIndex) {
                char character = characters[charIndex];
                if (isLastCharacterWhiteSpace && TextChunkUtils.isWhiteSpaceChar(character) || lastCharacter.charValue() == character) {
                    ++length;
                    continue;
                }
                if (length > 2) {
                    this.updateBoundingBox(resultBox, textChunk, start, charIndex);
                    if (!Character.isDigit(lastCharacter.charValue())) {
                        StaticContainers.getRepeatedCharacters().add(new RepeatedCharacters(!isLastCharacterWhiteSpace, length, resultBox));
                    }
                }
                resultBox = new MultiBoundingBox();
                length = 1;
                start = charIndex;
                lastCharacter = Character.valueOf(character);
                isLastCharacterWhiteSpace = TextChunkUtils.isWhiteSpaceChar(lastCharacter.charValue());
            }
            this.updateBoundingBox(resultBox, textChunk, start, characters.length);
        }
        if (length > 2 && !Character.isDigit(lastCharacter.charValue())) {
            StaticContainers.getRepeatedCharacters().add(new RepeatedCharacters(!isLastCharacterWhiteSpace, length, resultBox));
        }
    }

    private void updateBoundingBox(MultiBoundingBox resultBox, TextChunk textChunk, int start, int end) {
        BoundingBox boundingBox = new BoundingBox(textChunk.getBoundingBox());
        if (textChunk.isLeftRightHorizontalText()) {
            boundingBox.setLeftX(textChunk.getSymbolStartCoordinate(start));
            boundingBox.setRightX(textChunk.getSymbolEndCoordinate(end - 1));
        } else if (textChunk.isRightLeftHorizontalText()) {
            boundingBox.setLeftX(textChunk.getSymbolEndCoordinate(end - 1));
            boundingBox.setRightX(textChunk.getSymbolStartCoordinate(start));
        } else if (textChunk.isBottomUpVerticalText()) {
            boundingBox.setBottomY(textChunk.getSymbolStartCoordinate(start));
            boundingBox.setTopY(textChunk.getSymbolEndCoordinate(end - 1));
        } else if (textChunk.isUpBottomVerticalText()) {
            boundingBox.setBottomY(textChunk.getSymbolEndCoordinate(end - 1));
            boundingBox.setTopY(textChunk.getSymbolStartCoordinate(start));
        }
        resultBox.union(boundingBox);
    }

    private void updateIDs(ITree tree) {
        for (INode node : tree) {
            Long newId = StaticContainers.getIdMapper().get(node.getRecognizedStructureId());
            if (newId == null) continue;
            node.setRecognizedStructureId(newId);
        }
    }

    @Override
    public WCAGProgressStatus getWCAGProgressStatus() {
        return WCAGProgressStatus.DOCUMENT_POSTPROCESSING;
    }
}

