/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.consumers;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.verapdf.wcag.algorithms.entities.BaseObject;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.SemanticTable;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorder;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderCell;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.WCAGConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ErrorCodes;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.WCAGProgressStatus;

public class TableChecker
extends WCAGConsumer
implements Consumer<INode> {
    @Override
    public void accept(INode node) {
        if (node.getInitialSemanticType() != SemanticType.TABLE) {
            return;
        }
        node.setSemanticType(SemanticType.TABLE);
        TableChecker.checkTable(node);
    }

    private static void checkTable(INode table) {
        List<INode> tableRows = TableChecker.getTableRows(table);
        int numberOfRows = tableRows.size();
        if (numberOfRows == 0) {
            return;
        }
        int numberOfColumns = TableChecker.getNumberOfColumns(tableRows.get(0));
        TableBorderCell[][] cells = new TableBorderCell[numberOfRows][numberOfColumns];
        if (!TableChecker.checkRegular(tableRows, cells, numberOfRows, numberOfColumns)) {
            return;
        }
        TableChecker.setTableElementsID(table, tableRows, cells);
        TableChecker.checkTableCells(cells);
        TableChecker.checkTableCellsPosition(table, cells, numberOfRows, numberOfColumns);
        TableChecker.checkTableVisualRepresentation(table, cells, numberOfRows, numberOfColumns);
    }

    private static void setTableElementsID(INode table, List<INode> tableRows, TableBorderCell[][] cells) {
        Long id = StaticContainers.getNextID();
        table.setRecognizedStructureId(id);
        for (INode elem : table.getChildren()) {
            if (SemanticType.TABLE_FOOTER != elem.getInitialSemanticType() && SemanticType.TABLE_BODY != elem.getInitialSemanticType() && SemanticType.TABLE_HEADERS != elem.getInitialSemanticType()) continue;
            elem.setRecognizedStructureId(id);
        }
        for (INode row : tableRows) {
            row.setRecognizedStructureId(id);
        }
        for (int rowNumber = 0; rowNumber < cells.length; ++rowNumber) {
            for (int colNumber = 0; colNumber < cells[rowNumber].length; ++colNumber) {
                TableBorderCell cell = cells[rowNumber][colNumber];
                if (cell.getRowNumber() != rowNumber || cell.getColNumber() != colNumber) continue;
                cell.getNode().setRecognizedStructureId(id);
            }
        }
    }

    private static List<INode> getTableRows(INode table) {
        LinkedList<INode> listTR = new LinkedList<INode>();
        for (INode elem : table.getChildren()) {
            SemanticType type = elem.getInitialSemanticType();
            if (SemanticType.TABLE_ROW == type) {
                listTR.add(elem);
                continue;
            }
            if (SemanticType.TABLE_FOOTER != type && SemanticType.TABLE_BODY != type && SemanticType.TABLE_HEADERS != type) continue;
            for (INode child : elem.getChildren()) {
                if (SemanticType.TABLE_ROW != child.getInitialSemanticType()) continue;
                listTR.add(child);
            }
        }
        return listTR;
    }

    private static Integer getNumberOfColumns(INode firstTR) {
        int numberOfColumns = 0;
        for (INode elem : firstTR.getChildren()) {
            SemanticType type = elem.getInitialSemanticType();
            if (SemanticType.TABLE_HEADER != type && SemanticType.TABLE_CELL != type) continue;
            numberOfColumns = (int)((long)numberOfColumns + elem.getAttributesDictionary().getColSpan());
        }
        return numberOfColumns;
    }

    private static boolean checkRegular(List<INode> tableRows, TableBorderCell[][] cells, int numberOfRows, int numberOfColumns) {
        for (int rowNumber = 0; rowNumber < numberOfRows; ++rowNumber) {
            int columnNumber = 0;
            for (INode elem : tableRows.get(rowNumber).getChildren()) {
                SemanticType type = elem.getInitialSemanticType();
                if (SemanticType.TABLE_CELL != type && SemanticType.TABLE_HEADER != type) continue;
                while (columnNumber < numberOfColumns && cells[rowNumber][columnNumber] != null) {
                    ++columnNumber;
                }
                TableBorderCell cell = new TableBorderCell(elem, rowNumber, columnNumber);
                if (columnNumber >= numberOfColumns) {
                    return false;
                }
                if (rowNumber + cell.getRowSpan() > numberOfRows || columnNumber + cell.getColSpan() > numberOfColumns) {
                    return false;
                }
                if (!TableChecker.checkRegular(cells, cell).booleanValue()) {
                    return false;
                }
                columnNumber += cell.getColSpan();
            }
        }
        for (int i = 0; i < numberOfRows; ++i) {
            for (int j = 0; j < numberOfColumns; ++j) {
                if (cells[i][j] != null) continue;
                return false;
            }
        }
        return true;
    }

    private static Boolean checkRegular(TableBorderCell[][] cells, TableBorderCell cell) {
        for (int i = 0; i < cell.getRowSpan(); ++i) {
            for (int j = 0; j < cell.getColSpan(); ++j) {
                if (cells[cell.getRowNumber() + i][cell.getColNumber() + j] != null) {
                    return false;
                }
                cells[cell.getRowNumber() + i][cell.getColNumber() + j] = cell;
            }
        }
        return true;
    }

    private static void checkTableCells(TableBorderCell[][] cells) {
        for (int rowNumber = 0; rowNumber < cells.length; ++rowNumber) {
            for (int colNumber = 0; colNumber < cells[rowNumber].length; ++colNumber) {
                TableBorderCell cell = cells[rowNumber][colNumber];
                if (cell.getRowNumber() != rowNumber || cell.getColNumber() != colNumber) continue;
                if (TableChecker.isHeaderCell(cell.getNode(), cell, cells)) {
                    cell.getNode().setCorrectSemanticScore(1.0);
                    cell.getNode().setSemanticType(SemanticType.TABLE_HEADER);
                    cell.setSemanticType(SemanticType.TABLE_HEADER);
                    continue;
                }
                cell.getNode().setCorrectSemanticScore(1.0);
                cell.getNode().setSemanticType(SemanticType.TABLE_CELL);
                cell.setSemanticType(SemanticType.TABLE_CELL);
            }
        }
    }

    private static boolean isHeaderCell(INode cellNode, TableBorderCell cell, TableBorderCell[][] cells) {
        if (cellNode.getInitialSemanticType() != SemanticType.TABLE_HEADER) {
            return false;
        }
        if (cell.getColNumber() == 0 || cell.getRowNumber() == 0) {
            return true;
        }
        for (int rowNumber = cell.getRowNumber(); rowNumber < cell.getRowNumber() + cell.getRowSpan(); ++rowNumber) {
            if (cells[rowNumber][cell.getColNumber() - 1].getSemanticType() != SemanticType.TABLE_HEADER) continue;
            return true;
        }
        for (int colNumber = cell.getColNumber(); colNumber < cell.getColNumber() + cell.getColSpan(); ++colNumber) {
            if (cells[cell.getRowNumber() - 1][colNumber].getSemanticType() != SemanticType.TABLE_HEADER) continue;
            return true;
        }
        return false;
    }

    private static void checkTableCellsPosition(INode table, TableBorderCell[][] cells, int numberOfRows, int numberOfColumns) {
        if (table.getPageNumber() == null) {
            return;
        }
        TableChecker.checkTableCellsBottom(cells, numberOfRows);
        TableChecker.checkTableCellsTop(cells, numberOfRows);
        TableChecker.checkTableCellsRight(table, cells, numberOfColumns);
        TableChecker.checkTableCellsLeft(table, cells, numberOfColumns);
    }

    private static void checkTableCellsBottom(TableBorderCell[][] cells, int numberOfRows) {
        for (int rowNumber = 0; rowNumber < numberOfRows - 1; ++rowNumber) {
            TableBorderCell maxBottomCell = TableChecker.getMaxBottomCell(cells, rowNumber + 1);
            TableBorderCell minBottomCell = TableChecker.getMinBottomCell(cells, rowNumber);
            if (maxBottomCell == null || minBottomCell == null || !TableChecker.isFirstBottomMax(maxBottomCell.getBoundingBox(), minBottomCell.getBoundingBox()).booleanValue()) continue;
            ErrorCodes.addErrorCodeWithArguments(minBottomCell.getNode(), 1100, new Object[0]);
        }
    }

    private static void checkTableCellsTop(TableBorderCell[][] cells, int numberOfRows) {
        for (int rowNumber = 0; rowNumber < numberOfRows - 1; ++rowNumber) {
            TableBorderCell maxTopCell = TableChecker.getMaxTopCell(cells, rowNumber + 1);
            TableBorderCell minTopCell = TableChecker.getMinTopCell(cells, rowNumber);
            if (maxTopCell == null || minTopCell == null || !TableChecker.isFirstTopMax(maxTopCell.getBoundingBox(), minTopCell.getBoundingBox()).booleanValue()) continue;
            ErrorCodes.addErrorCodeWithArguments(maxTopCell.getNode(), 1101, new Object[0]);
        }
    }

    private static void checkTableCellsRight(INode table, TableBorderCell[][] cells, int numberOfColumns) {
        for (int pageNumber = table.getPageNumber().intValue(); pageNumber <= table.getLastPageNumber(); ++pageNumber) {
            for (int columnNumber = 0; columnNumber < numberOfColumns - 1; ++columnNumber) {
                TableBorderCell maxRightCell = TableChecker.getMaxRightCell(cells, columnNumber, pageNumber);
                TableBorderCell minRightCell = TableChecker.getMinRightCell(cells, columnNumber + 1, pageNumber);
                if (maxRightCell == null || minRightCell == null || !TableChecker.isFirstRightMax(maxRightCell.getBoundingBox(), minRightCell.getBoundingBox(), pageNumber).booleanValue()) continue;
                ErrorCodes.addErrorCodeWithArguments(maxRightCell.getNode(), 1102, new Object[0]);
            }
        }
    }

    private static void checkTableCellsLeft(INode table, TableBorderCell[][] cells, int numberOfColumns) {
        for (int pageNumber = table.getPageNumber().intValue(); pageNumber <= table.getLastPageNumber(); ++pageNumber) {
            for (int columnNumber = 0; columnNumber < numberOfColumns - 1; ++columnNumber) {
                TableBorderCell maxLeftCell = TableChecker.getMaxLeftCell(cells, columnNumber, pageNumber);
                TableBorderCell minLeftCell = TableChecker.getMinLeftCell(cells, columnNumber + 1, pageNumber);
                if (maxLeftCell == null || minLeftCell == null || !TableChecker.isFirstLeftMax(maxLeftCell.getBoundingBox(), minLeftCell.getBoundingBox(), pageNumber).booleanValue()) continue;
                ErrorCodes.addErrorCodeWithArguments(minLeftCell.getNode(), 1103, new Object[0]);
            }
        }
    }

    private static TableBorderCell getMaxTopCell(TableBorderCell[][] cells, int rowNumber) {
        TableBorderCell cell = null;
        for (int columnNumber = 0; columnNumber < cells[rowNumber].length; ++columnNumber) {
            TableBorderCell currentCell = cells[rowNumber][columnNumber];
            if (currentCell.getRowNumber() != rowNumber || currentCell.getColNumber() != columnNumber || currentCell.getBoundingBox().getPageNumber() == null || cell != null && !TableChecker.isFirstTopMax(currentCell.getBoundingBox(), cell.getBoundingBox()).booleanValue()) continue;
            cell = currentCell;
        }
        return cell;
    }

    private static TableBorderCell getMinTopCell(TableBorderCell[][] cells, int rowNumber) {
        BaseObject cell = null;
        for (int columnNumber = 0; columnNumber < cells[rowNumber].length; ++columnNumber) {
            TableBorderCell currentCell = cells[rowNumber][columnNumber];
            if (currentCell.getRowNumber() + currentCell.getRowSpan() != rowNumber + 1 || currentCell.getColNumber() != columnNumber || currentCell.getBoundingBox().getPageNumber() == null || cell != null && !TableChecker.isFirstTopMax(cell.getBoundingBox(), currentCell.getBoundingBox()).booleanValue()) continue;
            cell = currentCell;
        }
        return cell;
    }

    private static TableBorderCell getMaxBottomCell(TableBorderCell[][] cells, int rowNumber) {
        TableBorderCell cell = null;
        for (int columnNumber = 0; columnNumber < cells[rowNumber].length; ++columnNumber) {
            TableBorderCell currentCell = cells[rowNumber][columnNumber];
            if (currentCell.getRowNumber() != rowNumber || currentCell.getColNumber() != columnNumber || currentCell.getBoundingBox().getPageNumber() == null || cell != null && !TableChecker.isFirstBottomMax(currentCell.getBoundingBox(), cell.getBoundingBox()).booleanValue()) continue;
            cell = currentCell;
        }
        return cell;
    }

    private static TableBorderCell getMinBottomCell(TableBorderCell[][] cells, int rowNumber) {
        BaseObject cell = null;
        for (int columnNumber = 0; columnNumber < cells[rowNumber].length; ++columnNumber) {
            TableBorderCell currentCell = cells[rowNumber][columnNumber];
            if (currentCell.getRowNumber() + currentCell.getRowSpan() != rowNumber + 1 || currentCell.getColNumber() != columnNumber || currentCell.getBoundingBox().getPageNumber() == null || cell != null && !TableChecker.isFirstBottomMax(cell.getBoundingBox(), currentCell.getBoundingBox()).booleanValue()) continue;
            cell = currentCell;
        }
        return cell;
    }

    private static Boolean isFirstTopMax(BoundingBox boundingBox1, BoundingBox boundingBox2) {
        return boundingBox1.getPageNumber() < boundingBox2.getPageNumber() || boundingBox1.getPageNumber().equals(boundingBox2.getPageNumber()) && boundingBox1.getTopY() > boundingBox2.getTopY();
    }

    private static Boolean isFirstBottomMax(BoundingBox boundingBox1, BoundingBox boundingBox2) {
        return boundingBox1.getLastPageNumber() < boundingBox2.getLastPageNumber() || boundingBox1.getLastPageNumber().equals(boundingBox2.getLastPageNumber()) && boundingBox1.getBottomY() > boundingBox2.getBottomY();
    }

    private static TableBorderCell getMaxRightCell(TableBorderCell[][] cells, int columnNumber, int pageNumber) {
        TableBorderCell cell = null;
        for (int rowNumber = 0; rowNumber < cells.length; ++rowNumber) {
            TableBorderCell currentCell = cells[rowNumber][columnNumber];
            if (currentCell.getRowNumber() != rowNumber || currentCell.getColNumber() + currentCell.getColSpan() != columnNumber + 1 || currentCell.getBoundingBox().getPageNumber() == null || currentCell.getBoundingBox().getBoundingBox(pageNumber) == null || cell != null && !TableChecker.isFirstRightMax(currentCell.getBoundingBox(), cell.getBoundingBox(), pageNumber).booleanValue()) continue;
            cell = currentCell;
        }
        return cell;
    }

    private static TableBorderCell getMinRightCell(TableBorderCell[][] cells, int columnNumber, int pageNumber) {
        BaseObject cell = null;
        for (int rowNumber = 0; rowNumber < cells.length; ++rowNumber) {
            TableBorderCell currentCell = cells[rowNumber][columnNumber];
            if (currentCell.getRowNumber() != rowNumber || currentCell.getColNumber() != columnNumber || currentCell.getBoundingBox().getPageNumber() == null || currentCell.getBoundingBox().getBoundingBox(pageNumber) == null || cell != null && !TableChecker.isFirstRightMax(cell.getBoundingBox(), currentCell.getBoundingBox(), pageNumber).booleanValue()) continue;
            cell = currentCell;
        }
        return cell;
    }

    private static TableBorderCell getMaxLeftCell(TableBorderCell[][] cells, int columnNumber, int pageNumber) {
        TableBorderCell cell = null;
        for (int rowNumber = 0; rowNumber < cells.length; ++rowNumber) {
            TableBorderCell currentCell = cells[rowNumber][columnNumber];
            if (currentCell.getRowNumber() != rowNumber || currentCell.getColNumber() + currentCell.getColSpan() != columnNumber + 1 || currentCell.getBoundingBox().getPageNumber() == null || currentCell.getBoundingBox().getBoundingBox(pageNumber) == null || cell != null && !TableChecker.isFirstLeftMax(currentCell.getBoundingBox(), cell.getBoundingBox(), pageNumber).booleanValue()) continue;
            cell = currentCell;
        }
        return cell;
    }

    private static TableBorderCell getMinLeftCell(TableBorderCell[][] cells, int columnNumber, int pageNumber) {
        BaseObject cell = null;
        for (int rowNumber = 0; rowNumber < cells.length; ++rowNumber) {
            TableBorderCell currentCell = cells[rowNumber][columnNumber];
            if (currentCell.getRowNumber() != rowNumber || currentCell.getColNumber() != columnNumber || currentCell.getBoundingBox().getPageNumber() == null || currentCell.getBoundingBox().getBoundingBox(pageNumber) == null || cell != null && !TableChecker.isFirstLeftMax(cell.getBoundingBox(), currentCell.getBoundingBox(), pageNumber).booleanValue()) continue;
            cell = currentCell;
        }
        return cell;
    }

    private static Boolean isFirstRightMax(BoundingBox boundingBox1, BoundingBox boundingBox2, int pageNumber) {
        return boundingBox1.getRightX(pageNumber) > boundingBox2.getRightX(pageNumber);
    }

    private static Boolean isFirstLeftMax(BoundingBox boundingBox1, BoundingBox boundingBox2, int pageNumber) {
        return boundingBox1.getLeftX(pageNumber) > boundingBox2.getLeftX(pageNumber);
    }

    private static void checkTableVisualRepresentation(INode table, TableBorderCell[][] cells, int numberOfRows, int numberOfColumns) {
        if (table.getPageNumber() != null && !table.getPageNumber().equals(table.getLastPageNumber())) {
            return;
        }
        INode accumulatedNode = StaticContainers.getAccumulatedNodeMapper().get(table);
        if (!(accumulatedNode instanceof SemanticTable)) {
            return;
        }
        SemanticTable semanticTable = (SemanticTable)accumulatedNode;
        TableBorder border = semanticTable.getTableBorder();
        if (border == null) {
            return;
        }
        StaticContainers.getIdMapper().put(border.getRecognizedStructureId(), table.getRecognizedStructureId());
        if (border.getNumberOfRows() != numberOfRows) {
            ErrorCodes.addErrorCodeWithArguments(table, 1104, numberOfRows, border.getNumberOfRows());
            return;
        }
        if (border.getNumberOfColumns() != numberOfColumns) {
            ErrorCodes.addErrorCodeWithArguments(table, 1105, numberOfColumns, border.getNumberOfColumns());
            return;
        }
        for (int rowNumber = 0; rowNumber < numberOfRows; ++rowNumber) {
            for (int colNumber = 0; colNumber < numberOfColumns; ++colNumber) {
                TableBorderCell cell = cells[rowNumber][colNumber];
                TableBorderCell borderCell = border.getRow(rowNumber).getCell(colNumber);
                if (cell.getRowNumber() != rowNumber || cell.getColNumber() != colNumber || borderCell.getRowNumber() != rowNumber || borderCell.getColNumber() != colNumber) continue;
                if (cell.getRowSpan() != borderCell.getRowSpan()) {
                    ErrorCodes.addErrorCodeWithArguments(cell.getNode(), 1106, cell.getRowSpan(), borderCell.getRowSpan());
                }
                if (cell.getColSpan() == borderCell.getColSpan()) continue;
                ErrorCodes.addErrorCodeWithArguments(cell.getNode(), 1107, cell.getColSpan(), borderCell.getColSpan());
            }
        }
    }

    @Override
    public WCAGProgressStatus getWCAGProgressStatus() {
        return WCAGProgressStatus.TABLE_VALIDATION;
    }
}

