/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.tables;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.content.TextInfoChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.tables.TableToken;
import org.verapdf.wcag.algorithms.entities.tables.TableTokenRow;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorder;
import org.verapdf.wcag.algorithms.semanticalgorithms.tables.TableCluster;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ChunksMergeUtils;

public class TableRecognitionArea {
    private double adaptiveNextLineToleranceFactor = 1.05;
    private boolean hasCompleteHeaders = false;
    private boolean isComplete = false;
    private boolean isValid = false;
    private final List<TableCluster> headers = new ArrayList<TableCluster>();
    private final List<TableCluster> clusters = new ArrayList<TableCluster>();
    private BoundingBox boundingBox;
    private double headersBaseLine = Double.MAX_VALUE;
    private double baseLine = Double.MAX_VALUE;
    private TableBorder tableBorder;

    public TableRecognitionArea() {
        this.boundingBox = new BoundingBox();
    }

    public void setPageNumber(int pageNumber) {
        this.boundingBox.setPageNumber(pageNumber);
    }

    public Integer getPageNumber() {
        return this.boundingBox.getPageNumber();
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public boolean hasCompleteHeaders() {
        return this.hasCompleteHeaders;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public List<TableCluster> getHeaders() {
        return this.headers;
    }

    public List<TableCluster> getClusters() {
        return this.clusters;
    }

    public boolean addTokenToRecognitionArea(TextInfoChunk chunk) {
        if (this.isComplete) {
            return false;
        }
        if (chunk.getPageNumber() == null) {
            return false;
        }
        if (this.boundingBox.getPageNumber() == null) {
            this.boundingBox.setPageNumber(chunk.getPageNumber());
        } else if (!this.boundingBox.getPageNumber().equals(chunk.getPageNumber())) {
            this.isComplete = true;
            this.hasCompleteHeaders = true;
            this.headersBaseLine = this.baseLine;
            return false;
        }
        if (this.hasCompleteHeaders) {
            return this.addCluster(chunk);
        }
        if (this.belongsToHeadersArea(chunk)) {
            return this.expandHeaders(chunk);
        }
        this.hasCompleteHeaders = true;
        this.headersBaseLine = this.baseLine;
        if (this.checkHeaders()) {
            return this.addCluster(chunk);
        }
        this.isComplete = true;
        return false;
    }

    private boolean checkHeaders() {
        if (this.headers.size() < 2) {
            return false;
        }
        double avrFirstBaseLine = 0.0;
        double avrLastBaseLine = 0.0;
        double avrCenter = 0.0;
        for (TableCluster header : this.headers) {
            TableTokenRow firstLine = header.getFirstRow();
            TableTokenRow lastLine = header.getLastRow();
            avrFirstBaseLine += firstLine.getBaseLine();
            avrLastBaseLine += lastLine.getBaseLine();
            avrCenter += 0.5 * (firstLine.getBaseLine() + lastLine.getBaseLine());
        }
        avrFirstBaseLine /= (double)this.headers.size();
        avrLastBaseLine /= (double)this.headers.size();
        avrCenter /= (double)this.headers.size();
        double maxTopDeviation = 0.0;
        double maxBottomDeviation = 0.0;
        double maxCenterDeviation = 0.0;
        for (TableCluster header : this.headers) {
            TableTokenRow firstLine = header.getFirstRow();
            TableTokenRow lastLine = header.getLastRow();
            double fontSize = firstLine.getFontSize();
            double topDeviation = Math.abs(avrFirstBaseLine - firstLine.getBaseLine()) / fontSize;
            double bottomDeviation = Math.abs(avrLastBaseLine - lastLine.getBaseLine()) / fontSize;
            double centerDeviation = Math.abs(avrCenter - 0.5 * (firstLine.getBaseLine() + lastLine.getBaseLine())) / fontSize;
            if (maxTopDeviation < topDeviation) {
                maxTopDeviation = topDeviation;
            }
            if (maxBottomDeviation < bottomDeviation) {
                maxBottomDeviation = bottomDeviation;
            }
            if (!(maxCenterDeviation < centerDeviation)) continue;
            maxCenterDeviation = centerDeviation;
        }
        double headersProbability = 1.0 - Math.min(Math.min(maxTopDeviation, maxBottomDeviation), maxCenterDeviation);
        return headersProbability > 0.75;
    }

    private boolean belongsToHeadersArea(TextInfoChunk token) {
        if (this.headers.isEmpty()) {
            return true;
        }
        if (this.baseLine - token.getFirstBaseLine() > this.adaptiveNextLineToleranceFactor * token.getFontSize()) {
            return false;
        }
        return !(token.getBottomY() > this.boundingBox.getTopY() + 3.0 * token.getFontSize());
    }

    private boolean expandHeaders(TextInfoChunk token) {
        if (this.headers.isEmpty()) {
            TableCluster header = TableCluster.getTableCluster(token);
            header.setHeader(header);
            this.headers.add(header);
            this.boundingBox = new BoundingBox(token.getBoundingBox());
            this.baseLine = token.getBaseLine();
            return true;
        }
        boolean tokenAdded = false;
        TableCluster currentHeader = null;
        ArrayList<TableCluster> headersToRemove = new ArrayList<TableCluster>();
        for (TableCluster header : this.headers) {
            if (currentHeader == null) {
                if (!this.expandHeader(header, token)) continue;
                currentHeader = header;
                continue;
            }
            if (!this.joinHeaders(currentHeader, header, token)) continue;
            headersToRemove.add(header);
            tokenAdded = true;
        }
        if (currentHeader == null) {
            TableCluster header = TableCluster.getTableCluster(token);
            header.setHeader(header);
            this.headers.add(header);
            this.boundingBox.union(token.getBoundingBox());
            if (token.getBaseLine() < this.baseLine) {
                this.baseLine = token.getBaseLine();
            }
            return true;
        }
        this.headers.removeAll(headersToRemove);
        return tokenAdded;
    }

    private boolean expandHeader(TableCluster header, TextInfoChunk token) {
        double lineSpacingFactor;
        double baseLineDiff = Math.min(Math.abs(header.getBaseLine() - token.getBaseLine()), Math.abs(header.getFirstBaseLine() - token.getFirstBaseLine()));
        if (baseLineDiff < 0.9 * token.getFontSize() && ChunksMergeUtils.toLineMergeProbability(header.getLastToken(), token) > 0.75) {
            if (token instanceof TableCluster) {
                header.mergeWithoutRowNumbers((TableCluster)token);
            } else {
                header.add((TableToken)token);
            }
            if (token.getBaseLine() < this.baseLine) {
                this.baseLine = token.getBaseLine();
            }
            return true;
        }
        BoundingBox headerBBox = header.getBoundingBox();
        if (headerBBox.getLeftX() < token.getRightX() && token.getLeftX() < headerBBox.getRightX() && (lineSpacingFactor = baseLineDiff / token.getFontSize()) < 1.5) {
            if (this.adaptiveNextLineToleranceFactor < lineSpacingFactor) {
                this.adaptiveNextLineToleranceFactor = lineSpacingFactor * 1.05;
            }
            if (token instanceof TableCluster) {
                header.mergeWithoutRowNumbers((TableCluster)token);
            } else {
                header.add((TableToken)token, true);
            }
            if (token.getBaseLine() < this.baseLine) {
                this.baseLine = token.getBaseLine();
            }
            return true;
        }
        return false;
    }

    private boolean joinHeaders(TableCluster currentHeader, TableCluster header, TextInfoChunk token) {
        BoundingBox headerBBox = header.getBoundingBox();
        if (headerBBox.getLeftX() < token.getRightX() && token.getLeftX() < headerBBox.getRightX()) {
            currentHeader.mergeWithoutRowNumbers(header);
            this.boundingBox.union(token.getBoundingBox());
            if (token.getBaseLine() < this.baseLine) {
                this.baseLine = token.getBaseLine();
            }
            return true;
        }
        return false;
    }

    private boolean addCluster(TextInfoChunk token) {
        if (!token.getPageNumber().equals(token.getLastPageNumber())) {
            this.isComplete = true;
            return false;
        }
        if (this.baseLine - token.getFirstBaseLine() > 3.0 * token.getFontSize() || this.headersBaseLine < token.getBaseLine() || this.tableBorder != null && !this.tableBorder.getBoundingBox().contains(token.getBoundingBox())) {
            this.isComplete = true;
            return false;
        }
        if (Math.min(this.boundingBox.getLeftX() - token.getBoundingBox().getLeftX(), token.getBoundingBox().getRightX() - this.boundingBox.getRightX()) > 1.2 * token.getFontSize()) {
            this.isComplete = true;
            return false;
        }
        TableCluster cluster = TableCluster.getTableCluster(token);
        this.clusters.add(cluster);
        this.boundingBox.union(cluster.getBoundingBox());
        if (cluster.getBaseLine() < this.baseLine) {
            this.baseLine = cluster.getBaseLine();
        }
        this.isValid = true;
        return true;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("TableRecognitionArea{\n");
        result.append("    headers={\n");
        for (TableCluster header : this.headers) {
            result.append('[').append(header).append("]\n");
        }
        result.append("    }, clusters={\n");
        for (TableCluster cluster : this.clusters) {
            result.append('[').append(cluster).append("] : [").append(cluster.getHeader()).append("]\n");
        }
        result.append("    }, boundingBox=").append(this.boundingBox).append('\n');
        result.append("    , baseLine=").append(this.baseLine).append("\n}");
        return result.toString();
    }

    public TableBorder getTableBorder() {
        return this.tableBorder;
    }

    public void setTableBorder(TableBorder tableBorder) {
        this.tableBorder = tableBorder;
    }
}

