/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.content;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.SemanticFigure;
import org.verapdf.wcag.algorithms.entities.content.IChunk;
import org.verapdf.wcag.algorithms.entities.content.LineArtChunk;
import org.verapdf.wcag.algorithms.entities.content.LineChunk;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;

public class LinesCollection {
    private final Map<Integer, SortedSet<LineChunk>> horizontalLines = new HashMap<Integer, SortedSet<LineChunk>>();
    private final Map<Integer, SortedSet<LineChunk>> verticalLines = new HashMap<Integer, SortedSet<LineChunk>>();
    private final Map<Integer, SortedSet<LineChunk>> squares = new HashMap<Integer, SortedSet<LineChunk>>();

    public SortedSet<LineChunk> getHorizontalLines(Integer pageNumber) {
        SortedSet<LineChunk> horizontalLines = this.horizontalLines.get(pageNumber);
        if (horizontalLines == null) {
            this.parseLines();
            horizontalLines = this.horizontalLines.get(pageNumber);
            if (horizontalLines == null) {
                this.horizontalLines.put(pageNumber, new TreeSet<LineChunk>(new LineChunk.HorizontalLineComparator()));
                horizontalLines = this.horizontalLines.get(pageNumber);
            }
        }
        return horizontalLines;
    }

    private void parseLines() {
        for (int pageNumber = 0; pageNumber < StaticContainers.getDocument().getNumberOfPages(); ++pageNumber) {
            this.parseLines(pageNumber);
        }
        this.parseLines(StaticContainers.getDocument().getTree().getRoot());
    }

    private void parseLines(INode node) {
        for (INode child : node.getChildren()) {
            List<LineArtChunk> lineArts;
            if (child.getInitialSemanticType() != SemanticType.FIGURE) {
                this.parseLines(child);
            }
            if (!(child instanceof SemanticFigure) || (lineArts = ((SemanticFigure)child).getLineArts()).isEmpty()) continue;
            LineArtChunk lineArt = lineArts.get(0);
            for (LineChunk lineChunk : lineArt.getLineChunks()) {
                if (lineChunk.isHorizontalLine()) {
                    this.horizontalLines.get(lineChunk.getPageNumber()).add(lineChunk);
                    continue;
                }
                if (lineChunk.isVerticalLine()) {
                    this.verticalLines.get(lineChunk.getPageNumber()).add(lineChunk);
                    continue;
                }
                if (!lineChunk.isSquare()) continue;
                this.squares.get(lineChunk.getPageNumber()).add(lineChunk);
            }
        }
    }

    private void parseLines(Integer pageNumber) {
        TreeSet<LineChunk> horizontalLines = new TreeSet<LineChunk>(new LineChunk.HorizontalLineComparator());
        TreeSet<LineChunk> verticalLines = new TreeSet<LineChunk>(new LineChunk.VerticalLineComparator());
        TreeSet<LineChunk> squares = new TreeSet<LineChunk>(new LineChunk.VerticalLineComparator());
        for (IChunk chunk : StaticContainers.getDocument().getArtifacts(pageNumber)) {
            if (!(chunk instanceof LineChunk)) continue;
            LineChunk lineChunk = (LineChunk)chunk;
            if (lineChunk.isHorizontalLine()) {
                horizontalLines.add(lineChunk);
                continue;
            }
            if (lineChunk.isVerticalLine()) {
                verticalLines.add(lineChunk);
                continue;
            }
            if (!lineChunk.isSquare()) continue;
            squares.add(lineChunk);
        }
        this.horizontalLines.put(pageNumber, horizontalLines);
        this.verticalLines.put(pageNumber, verticalLines);
        this.squares.put(pageNumber, squares);
    }

    public SortedSet<LineChunk> getVerticalLines(Integer pageNumber) {
        SortedSet<LineChunk> verticalLines = this.verticalLines.get(pageNumber);
        if (verticalLines == null) {
            this.parseLines();
            verticalLines = this.verticalLines.get(pageNumber);
            if (verticalLines == null) {
                this.verticalLines.put(pageNumber, new TreeSet<LineChunk>(new LineChunk.VerticalLineComparator()));
                verticalLines = this.verticalLines.get(pageNumber);
            }
        }
        return verticalLines;
    }

    public SortedSet<LineChunk> getSquares(Integer pageNumber) {
        SortedSet<LineChunk> squares = this.squares.get(pageNumber);
        if (squares == null) {
            this.parseLines();
            squares = this.squares.get(pageNumber);
            if (squares == null) {
                this.squares.put(pageNumber, new TreeSet<LineChunk>(new LineChunk.VerticalLineComparator()));
                squares = this.squares.get(pageNumber);
            }
        }
        return squares;
    }
}

