/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.tables;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.tables.TableBorderBuilder;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorder;

public class TableBordersCollection {
    private final List<SortedSet<TableBorder>> tableBorders;

    public TableBordersCollection() {
        this.tableBorders = new ArrayList<SortedSet<TableBorder>>();
    }

    public TableBordersCollection(List<List<TableBorderBuilder>> tableBorderBuilders) {
        this.tableBorders = new ArrayList<SortedSet<TableBorder>>(tableBorderBuilders.size());
        for (List<TableBorderBuilder> builders : tableBorderBuilders) {
            TreeSet<TableBorder> borders = new TreeSet<TableBorder>(new TableBorder.TableBordersComparator());
            for (TableBorderBuilder builder : builders) {
                TableBorder border = new TableBorder(builder);
                if (border.isBadTable()) continue;
                borders.add(border);
            }
            this.tableBorders.add(borders);
        }
    }

    public List<SortedSet<TableBorder>> getTableBorders() {
        return this.tableBorders;
    }

    public SortedSet<TableBorder> getTableBorders(Integer pageNumber) {
        if (pageNumber != null && pageNumber < this.tableBorders.size()) {
            return this.tableBorders.get(pageNumber);
        }
        return new TreeSet<TableBorder>();
    }

    public TableBorder getTableBorder(BoundingBox boundingBox) {
        SortedSet<TableBorder> tableBorders = this.getTableBorders(boundingBox.getPageNumber());
        for (TableBorder tableBorder : tableBorders) {
            if (!tableBorder.getBoundingBox().contains(boundingBox, 0.6, 0.6)) continue;
            return tableBorder;
        }
        return null;
    }
}

