/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.tables.Table;
import org.verapdf.wcag.algorithms.entities.tables.TableCell;
import org.verapdf.wcag.algorithms.entities.tables.TableRow;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.ClusterTableConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.TableBorderConsumer;

public class HeadingUtils {
    private static final Set<SemanticType> headingSemanticTypes = new HashSet<SemanticType>(Arrays.asList(SemanticType.HEADING, SemanticType.NUMBER_HEADING));

    public static boolean isHeadings(Table table) {
        for (TableRow row : table.getRows()) {
            List<TableCell> cells = row.getCells();
            if (cells.size() != 2) {
                return false;
            }
            TableCell cell = cells.get(0);
            if (!cell.isTextCell() || cell.getContent().isEmpty()) continue;
            HashSet<INode> nodes = new HashSet<INode>();
            nodes.add(ClusterTableConsumer.getTableCellNode(cell));
            nodes.add(ClusterTableConsumer.getTableCellNode(cells.get(1)));
            boolean isHeading = false;
            for (INode node = TableBorderConsumer.findCommonParent(nodes); node != null; node = node.getParent()) {
                if (!HeadingUtils.isInitialHeadingNode(node) && node.getInitialSemanticType() != SemanticType.TITLE) continue;
                isHeading = true;
                break;
            }
            if (isHeading) continue;
            return false;
        }
        return true;
    }

    public static boolean isDetectedHeadingNode(INode node) {
        return headingSemanticTypes.contains((Object)node.getSemanticType());
    }

    public static boolean isInitialHeadingNode(INode node) {
        return headingSemanticTypes.contains((Object)node.getInitialSemanticType());
    }
}

