/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.chunks;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSNumber;
import org.verapdf.gf.model.factory.chunks.Matrix;
import org.verapdf.gf.model.factory.chunks.TextState;
import org.verapdf.gf.model.impl.sa.util.ResourceHandler;
import org.verapdf.pd.PDExtGState;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.font.PDFont;

public class GraphicsState
implements Cloneable {
    private Matrix CTM = new Matrix();
    private TextState textState = new TextState();
    private double[] fillColor = new double[]{0.0};
    private PDColorSpace fillColorSpace;
    private boolean processColorOperators = true;
    private double lineWidth = 1.0;
    private int lineCap = 0;

    private GraphicsState() {
    }

    public GraphicsState(ResourceHandler resourceHandler) {
        this.fillColorSpace = resourceHandler.getColorSpace(ASAtom.DEVICEGRAY);
    }

    public PDColorSpace getFillColorSpace() {
        return this.fillColorSpace;
    }

    public void setFillColorSpace(PDColorSpace fillColorSpace) {
        this.fillColorSpace = fillColorSpace;
    }

    public boolean isProcessColorOperators() {
        return this.processColorOperators;
    }

    public void disableColorOperators() {
        this.processColorOperators = false;
    }

    public Matrix getCTM() {
        return this.CTM;
    }

    public void setCTM(Matrix CTM) {
        this.CTM = CTM.clone();
    }

    public TextState getTextState() {
        return this.textState;
    }

    public void setTextState(TextState textState) {
        this.textState = textState.clone();
    }

    public double[] getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(double[] fillColor) {
        this.fillColor = (double[])fillColor.clone();
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public int getLineCap() {
        return this.lineCap;
    }

    public void setLineCap(int lineCap) {
        this.lineCap = lineCap;
    }

    public void copyProperties(GraphicsState graphicState) {
        this.CTM = graphicState.getCTM();
        this.textState = graphicState.getTextState();
        this.fillColor = graphicState.getFillColor();
        this.fillColorSpace = graphicState.getFillColorSpace();
        this.processColorOperators = graphicState.isProcessColorOperators();
        this.lineWidth = graphicState.getLineWidth();
        this.lineCap = graphicState.getLineCap();
    }

    public void copyPropertiesFromExtGState(PDExtGState extGState) {
        if (extGState != null) {
            COSNumber fontSize;
            PDFont font = extGState.getFont();
            if (font != null) {
                this.getTextState().setTextFont(font);
            }
            if ((fontSize = extGState.getCOSFontSize()) != null) {
                this.getTextState().setTextFontSize(fontSize.getReal());
            }
        }
    }

    public GraphicsState clone() {
        GraphicsState clone = new GraphicsState();
        clone.CTM = this.CTM.clone();
        clone.textState = this.textState.clone();
        clone.fillColor = this.fillColor;
        clone.fillColorSpace = this.fillColorSpace;
        clone.processColorOperators = this.processColorOperators;
        clone.lineWidth = this.lineWidth;
        clone.lineCap = this.lineCap;
        return clone;
    }
}

