/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.sa;

import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.containers.StaticStorages;
import org.verapdf.gf.model.impl.sa.GFSALinkAnnotation;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.salayer.SAAnnotation;
import org.verapdf.pd.PDAnnotation;
import org.verapdf.pd.PDPage;
import org.verapdf.pd.structure.PDNumberTreeNode;
import org.verapdf.pd.structure.PDStructTreeRoot;
import org.verapdf.tools.StaticResources;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;

public class GFSAAnnotation
extends GenericModelObject
implements SAAnnotation {
    public static final String ANNOTATION_TYPE = "SAAnnotation";
    public static final String LINK = "Link";
    private final PDAnnotation annot;
    private final PDPage page;
    private String textValue;

    public GFSAAnnotation(PDAnnotation annot, PDPage page) {
        this(annot, page, ANNOTATION_TYPE);
    }

    public GFSAAnnotation(PDAnnotation annot, PDPage page, String type) {
        super(type);
        this.page = page;
        this.annot = annot;
    }

    public String gettextValue() {
        if (this.textValue == null) {
            this.textValue = this.findTextValue();
        }
        return this.textValue;
    }

    private String findTextValue() {
        double[] rect = this.annot.getRect();
        if (rect != null) {
            List<String> values = StaticStorages.getChunks().getValues(this.page.getObject().getKey(), new BoundingBox(Integer.valueOf(this.page.getPageNumber()), rect));
            return values.stream().reduce("", String::concat).trim();
        }
        return "";
    }

    public static GFSAAnnotation createAnnot(PDAnnotation annot, PDPage page) {
        String subtypeString;
        ASAtom subtype = annot.getSubtype();
        if (subtype == null) {
            return new GFSAAnnotation(annot, page);
        }
        switch (subtypeString = subtype.getValue()) {
            case "Link": {
                return new GFSALinkAnnotation(annot, page);
            }
        }
        return new GFSAAnnotation(annot, page);
    }

    public Boolean getisOutsideCropBox() {
        double[] cropBox = this.page.getCropBox();
        double[] rectangle = this.annot.getRect();
        if (rectangle != null && rectangle.length >= 4) {
            return cropBox[1] >= rectangle[3] || cropBox[0] >= rectangle[2] || cropBox[3] <= rectangle[1] || cropBox[2] <= rectangle[0];
        }
        return null;
    }

    public String getContents() {
        return this.annot.getContents();
    }

    public String getAlt() {
        PDStructTreeRoot structTreeRoot = StaticResources.getDocument().getStructTreeRoot();
        Long structParent = this.annot.getStructParent();
        if (structTreeRoot != null && structParent != null) {
            COSObject baseAlt;
            COSObject structureElement;
            PDNumberTreeNode parentTreeRoot = structTreeRoot.getParentTree();
            COSObject cOSObject = structureElement = parentTreeRoot == null ? null : parentTreeRoot.getObject(structParent);
            if (structureElement != null && (baseAlt = structureElement.getKey(ASAtom.ALT)) != null && baseAlt.getType() == COSObjType.COS_STRING) {
                return baseAlt.getDirectBase().toString();
            }
        }
        return null;
    }

    public Long getF() {
        return this.annot.getF();
    }
}

