/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.chunks;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.factory.chunks.GraphicsState;
import org.verapdf.gf.model.factory.chunks.Matrix;
import org.verapdf.gf.model.factory.chunks.Path;
import org.verapdf.gf.model.factory.chunks.Rectangle;
import org.verapdf.gf.model.impl.containers.StaticStorages;
import org.verapdf.gf.model.impl.sa.util.ResourceHandler;
import org.verapdf.operator.Operator;
import org.verapdf.pd.PDResource;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.colors.PDDeviceCMYK;
import org.verapdf.pd.colors.PDDeviceGray;
import org.verapdf.pd.colors.PDDeviceRGB;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.images.PDXObject;
import org.verapdf.wcag.algorithms.entities.content.IChunk;
import org.verapdf.wcag.algorithms.entities.content.ImageChunk;
import org.verapdf.wcag.algorithms.entities.content.LineChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;

class ChunkParser {
    private static final Logger LOGGER = Logger.getLogger(ChunkParser.class.getName());
    private final Deque<GraphicsState> graphicsStateStack = new ArrayDeque<GraphicsState>();
    private final Stack<Long> markedContentStack = new Stack();
    private final Integer pageNumber;
    private final COSKey pageObjectNumber;
    private Matrix textMatrix = null;
    private Matrix textLineMatrix = null;
    private final GraphicsState graphicsState;
    private final Path path = new Path();
    private final List<IChunk> artifacts = new LinkedList<IChunk>();
    private List<Object> nonDrawingArtifacts = new LinkedList<Object>();
    private final double[] cropBox;

    public ChunkParser(Integer pageNumber, COSKey pageObjectNumber, ResourceHandler resourceHandler, double[] cropBox) {
        this.pageNumber = pageNumber;
        this.pageObjectNumber = pageObjectNumber;
        this.graphicsState = new GraphicsState(resourceHandler);
        this.cropBox = cropBox;
    }

    public List<IChunk> getArtifacts() {
        return this.artifacts;
    }

    public void parseChunk(Operator rawOperator, ResourceHandler resourceHandler, List<COSBase> arguments) {
        String operatorName;
        switch (operatorName = rawOperator.getOperator()) {
            case "BMC": {
                this.markedContentStack.push(this.getMCID(arguments, resourceHandler));
                break;
            }
            case "BDC": {
                this.markedContentStack.push(this.getMCID(arguments, resourceHandler));
                break;
            }
            case "EMC": {
                this.markedContentStack.pop();
                break;
            }
            case "g": {
                if (!this.graphicsState.isProcessColorOperators()) break;
                ChunkParser.processColorSpace(this.graphicsState, resourceHandler, (PDColorSpace)PDDeviceGray.INSTANCE, ASAtom.DEVICEGRAY, false);
                if (this.isProcessColorSpace(this.graphicsState.getFillColorSpace().getType())) {
                    Double fillColor = this.getValueOfLastNumber(arguments);
                    if (fillColor == null) break;
                    this.graphicsState.setFillColor(new double[]{fillColor});
                    break;
                }
                this.graphicsState.setFillColor(new double[0]);
                break;
            }
            case "rg": {
                if (!this.graphicsState.isProcessColorOperators()) break;
                ChunkParser.processColorSpace(this.graphicsState, resourceHandler, (PDColorSpace)PDDeviceRGB.INSTANCE, ASAtom.DEVICERGB, false);
                if (this.isProcessColorSpace(this.graphicsState.getFillColorSpace().getType())) {
                    if (arguments.size() != 3 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber()) break;
                    this.graphicsState.setFillColor(new double[]{arguments.get(0).getReal(), arguments.get(1).getReal(), arguments.get(2).getReal()});
                    break;
                }
                this.graphicsState.setFillColor(new double[0]);
                break;
            }
            case "k": {
                if (!this.graphicsState.isProcessColorOperators()) break;
                ChunkParser.processColorSpace(this.graphicsState, resourceHandler, (PDColorSpace)PDDeviceCMYK.INSTANCE, ASAtom.DEVICECMYK, false);
                if (this.isProcessColorSpace(this.graphicsState.getFillColorSpace().getType())) {
                    if (arguments.size() != 4 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber() || !arguments.get(3).getType().isNumber()) break;
                    this.graphicsState.setFillColor(new double[]{arguments.get(0).getReal(), arguments.get(1).getReal(), arguments.get(2).getReal(), arguments.get(3).getReal()});
                    break;
                }
                this.graphicsState.setFillColor(new double[0]);
                break;
            }
            case "scn": {
                if (!this.graphicsState.isProcessColorOperators()) break;
                if (this.isProcessColorSpace(this.graphicsState.getFillColorSpace().getType())) {
                    if (arguments.size() == 1 || arguments.size() == 2) {
                        if (!arguments.get(0).getType().isNumber()) break;
                        this.graphicsState.setFillColor(new double[]{arguments.get(0).getReal()});
                        break;
                    }
                    if (arguments.size() == 3 || arguments.size() == 4 && !arguments.get(3).getType().isNumber()) {
                        if (!arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber()) break;
                        this.graphicsState.setFillColor(new double[]{arguments.get(0).getReal(), arguments.get(1).getReal(), arguments.get(2).getReal()});
                        break;
                    }
                    if (arguments.size() != 4 && arguments.size() != 5 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber() || !arguments.get(3).getType().isNumber()) break;
                    this.graphicsState.setFillColor(new double[]{arguments.get(0).getReal(), arguments.get(1).getReal(), arguments.get(2).getReal(), arguments.get(3).getReal()});
                    break;
                }
                this.graphicsState.setFillColor(new double[0]);
                break;
            }
            case "sc": {
                if (!this.graphicsState.isProcessColorOperators()) break;
                if (this.isProcessColorSpace(this.graphicsState.getFillColorSpace().getType())) {
                    if (arguments.size() == 1) {
                        if (!arguments.get(0).getType().isNumber()) break;
                        this.graphicsState.setFillColor(new double[]{arguments.get(0).getReal()});
                        break;
                    }
                    if (arguments.size() == 3) {
                        if (!arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber()) break;
                        this.graphicsState.setFillColor(new double[]{arguments.get(0).getReal(), arguments.get(1).getReal(), arguments.get(2).getReal()});
                        break;
                    }
                    if (arguments.size() != 4 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber() || !arguments.get(3).getType().isNumber()) break;
                    this.graphicsState.setFillColor(new double[]{arguments.get(0).getReal(), arguments.get(1).getReal(), arguments.get(2).getReal(), arguments.get(3).getReal()});
                    break;
                }
                this.graphicsState.setFillColor(new double[0]);
                break;
            }
            case "cs": {
                if (!this.graphicsState.isProcessColorOperators()) break;
                this.graphicsState.setFillColorSpace(resourceHandler.getColorSpace(ChunkParser.getLastCOSName(arguments)));
                break;
            }
            case "ET": {
                this.textMatrix = null;
                this.textLineMatrix = null;
                break;
            }
            case "BT": {
                this.textMatrix = new Matrix();
                this.textLineMatrix = new Matrix();
                break;
            }
            case "Td": {
                if (arguments.size() <= 1 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber()) break;
                this.processTd(arguments.get(0).getReal(), arguments.get(1).getReal());
                break;
            }
            case "TD": {
                if (arguments.size() <= 1 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber()) break;
                this.processTD(arguments.get(0).getReal(), arguments.get(1).getReal());
                break;
            }
            case "Tm": {
                this.textMatrix = new Matrix(arguments);
                this.textLineMatrix = this.textMatrix.clone();
                break;
            }
            case "T*": {
                this.processT_STAR();
                break;
            }
            case "Tj": {
                TextChunk textChunk = this.createTextChunk(arguments, "Tj");
                if (textChunk == null) break;
                this.putChunk(this.getMarkedContent(), (IChunk)textChunk);
                break;
            }
            case "TJ": {
                TextChunk textChunk = this.createTextChunk(arguments, "TJ");
                if (textChunk == null) break;
                this.putChunk(this.getMarkedContent(), (IChunk)textChunk);
                break;
            }
            case "'": {
                this.processT_STAR();
                TextChunk textChunk = this.createTextChunk(arguments, "'");
                if (textChunk == null) break;
                this.putChunk(this.getMarkedContent(), (IChunk)textChunk);
                break;
            }
            case "\"": {
                TextChunk textChunk;
                if (arguments.size() > 1 && arguments.get(0).getType().isNumber() && arguments.get(1).getType().isNumber()) {
                    this.processDoubleQuote(arguments.get(0).getReal(), arguments.get(1).getReal());
                }
                if ((textChunk = this.createTextChunk(arguments, "\"")) == null) break;
                this.putChunk(this.getMarkedContent(), (IChunk)textChunk);
                break;
            }
            case "Tz": {
                Double horizontalScaling = this.getValueOfLastNumber(arguments);
                if (horizontalScaling == null) break;
                this.graphicsState.getTextState().setHorizontalScaling(horizontalScaling / 100.0);
                break;
            }
            case "Tf": {
                COSBase textFontSize;
                this.graphicsState.getTextState().setTextFont(resourceHandler.getFont(ChunkParser.getFirstCOSName(arguments)));
                if (arguments.size() <= 1 || !(textFontSize = arguments.get(1)).getType().isNumber()) break;
                this.graphicsState.getTextState().setTextFontSize(textFontSize.getReal());
                break;
            }
            case "Tc": {
                Double characterSpacing = this.getValueOfLastNumber(arguments);
                if (characterSpacing == null) break;
                this.graphicsState.getTextState().setCharacterSpacing(characterSpacing);
                break;
            }
            case "Tw": {
                Double wordSpacing = this.getValueOfLastNumber(arguments);
                if (wordSpacing == null) break;
                this.graphicsState.getTextState().setWordSpacing(wordSpacing);
                break;
            }
            case "TL": {
                Double textLeading = this.getValueOfLastNumber(arguments);
                if (textLeading == null) break;
                this.graphicsState.getTextState().setTextLeading(textLeading);
                break;
            }
            case "Ts": {
                Double textRise = this.getValueOfLastNumber(arguments);
                if (textRise == null) break;
                this.graphicsState.getTextState().setTextRise(textRise);
                break;
            }
            case "BI": {
                this.putChunk(this.getMarkedContent(), (IChunk)new ImageChunk(new BoundingBox(this.pageNumber.intValue(), this.parseImageBoundingBox())));
                break;
            }
            case "c": {
                if (arguments.size() != 6 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber() || !arguments.get(3).getType().isNumber() || !arguments.get(4).getType().isNumber() || !arguments.get(5).getType().isNumber()) break;
                double x3 = arguments.get(4).getReal();
                double y3 = arguments.get(5).getReal();
                this.path.setCurrentPoint(x3, y3);
                break;
            }
            case "h": {
                this.processh();
                break;
            }
            case "f": 
            case "F": 
            case "f*": {
                this.processf();
                break;
            }
            case "l": {
                if (arguments.size() != 2 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber()) break;
                double x = arguments.get(0).getReal();
                double y = arguments.get(1).getReal();
                this.nonDrawingArtifacts.add(new LineChunk(this.pageNumber, this.path.getCurrentX(), this.path.getCurrentY(), x, y, this.graphicsState.getLineWidth()));
                this.path.setCurrentPoint(x, y);
                break;
            }
            case "m": {
                if (arguments.size() != 2 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber()) break;
                double x = arguments.get(0).getReal();
                double y = arguments.get(1).getReal();
                this.path.setStartPoint(x, y);
                this.path.setCurrentPoint(x, y);
                break;
            }
            case "w": {
                if (arguments.size() != 1 || !arguments.get(0).getType().isNumber()) break;
                this.graphicsState.setLineWidth(Math.max(1.0, arguments.get(0).getReal()));
                break;
            }
            case "J": {
                if (arguments.size() != 1 || arguments.get(0).getType() != COSObjType.COS_INTEGER) break;
                this.graphicsState.setLineCap(arguments.get(0).getInteger().intValue());
                break;
            }
            case "re": {
                if (arguments.size() != 4 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber() || !arguments.get(3).getType().isNumber()) break;
                double x = arguments.get(0).getReal();
                double y = arguments.get(1).getReal();
                this.nonDrawingArtifacts.add(new Rectangle(this.pageNumber, x, y, arguments.get(2).getReal(), arguments.get(3).getReal()));
                this.path.setCurrentPoint(x, y);
                this.path.setStartPoint(x, y);
                break;
            }
            case "v": {
                if (arguments.size() != 4 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber() || !arguments.get(3).getType().isNumber()) break;
                this.path.setCurrentPoint(arguments.get(2).getReal(), arguments.get(3).getReal());
                break;
            }
            case "y": {
                if (arguments.size() != 4 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber() || !arguments.get(3).getType().isNumber()) break;
                this.path.setCurrentPoint(arguments.get(2).getReal(), arguments.get(3).getReal());
                break;
            }
            case "b": {
                this.processh();
                this.processB();
                break;
            }
            case "B": {
                this.processB();
                break;
            }
            case "b*": {
                this.processh();
                this.processB();
                break;
            }
            case "B*": {
                this.processB();
                break;
            }
            case "n": {
                this.nonDrawingArtifacts = new LinkedList<Object>();
                break;
            }
            case "s": {
                this.processh();
                this.processS();
                break;
            }
            case "S": {
                this.processS();
                break;
            }
            case "cm": {
                this.graphicsState.getCTM().concatenate(new Matrix(arguments));
                break;
            }
            case "Q": {
                if (this.graphicsStateStack.isEmpty()) break;
                this.graphicsState.copyProperties(this.graphicsStateStack.pop());
                break;
            }
            case "q": {
                this.graphicsStateStack.push(this.graphicsState.clone());
                break;
            }
            case "Do": {
                PDXObject xObject = resourceHandler.getXObject(ChunkParser.getLastCOSName(arguments));
                if (xObject == null || !ASAtom.IMAGE.equals((Object)xObject.getType())) break;
                this.putChunk(this.getMarkedContent(), (IChunk)new ImageChunk(new BoundingBox(this.pageNumber.intValue(), this.parseImageBoundingBox())));
                break;
            }
            case "d1": {
                this.graphicsState.disableColorOperators();
                break;
            }
        }
    }

    private static COSName getFirstCOSName(List<COSBase> arguments) {
        COSBase lastElement;
        COSBase cOSBase = lastElement = arguments.isEmpty() ? null : arguments.get(0);
        if (lastElement instanceof COSName) {
            return (COSName)lastElement;
        }
        return null;
    }

    private static COSName getLastCOSName(List<COSBase> arguments) {
        COSBase lastElement;
        COSBase cOSBase = lastElement = arguments.isEmpty() ? null : arguments.get(arguments.size() - 1);
        if (lastElement instanceof COSName) {
            return (COSName)lastElement;
        }
        return null;
    }

    private void processT_STAR() {
        this.processTD(0.0, -this.graphicsState.getTextState().getTextLeading());
    }

    private void processTD(double op1, double op2) {
        this.graphicsState.getTextState().setTextLeading(-op2);
        this.processTd(op1, op2);
    }

    private void processTd(double op1, double op2) {
        if (this.textLineMatrix != null) {
            this.textLineMatrix.concatenate(Matrix.getTranslateInstance(op1, op2));
            this.textMatrix = this.textLineMatrix.clone();
        } else {
            LOGGER.log(Level.WARNING, "Text operator not inside text content");
        }
    }

    private void processDoubleQuote(double op1, double op2) {
        this.graphicsState.getTextState().setWordSpacing(op1);
        this.graphicsState.getTextState().setCharacterSpacing(op2);
    }

    private void processh() {
        this.artifacts.add((IChunk)new LineChunk(this.pageNumber, this.path.getStartX(), this.path.getStartY(), this.path.getCurrentX(), this.path.getCurrentY(), this.graphicsState.getLineWidth()));
        this.path.setCurrentPoint(this.path.getStartX(), this.path.getStartY());
    }

    private void processB() {
        for (Object chunk : this.nonDrawingArtifacts) {
            LineChunk line;
            if (chunk instanceof LineChunk) {
                this.artifacts.add((IChunk)this.transformLineChunk((LineChunk)chunk, this.graphicsState.getCTM(), this.graphicsState.getLineWidth(), this.graphicsState.getLineCap()));
                continue;
            }
            if (!(chunk instanceof Rectangle) || (line = ((Rectangle)chunk).getLine(this.graphicsState.getLineWidth())) == null) continue;
            this.artifacts.add((IChunk)this.transformLineChunk(line, this.graphicsState.getCTM(), line.getWidth(), LineChunk.PROJECTING_SQUARE_CAP_STYLE));
        }
        this.nonDrawingArtifacts = new LinkedList<Object>();
    }

    private void processS() {
        for (Object chunk : this.nonDrawingArtifacts) {
            if (chunk instanceof LineChunk) {
                this.artifacts.add((IChunk)this.transformLineChunk((LineChunk)chunk, this.graphicsState.getCTM(), this.graphicsState.getLineWidth(), this.graphicsState.getLineCap()));
                continue;
            }
            if (!(chunk instanceof Rectangle)) continue;
            Rectangle rectangle = (Rectangle)chunk;
            if (rectangle.getHeight() < this.graphicsState.getLineWidth() || rectangle.getWidth() < this.graphicsState.getLineWidth()) {
                LineChunk line = rectangle.getLine(this.graphicsState.getLineWidth());
                if (line == null) continue;
                this.artifacts.add((IChunk)this.transformLineChunk(line, this.graphicsState.getCTM(), line.getWidth(), LineChunk.PROJECTING_SQUARE_CAP_STYLE));
                continue;
            }
            List<LineChunk> lines = rectangle.getLines(this.graphicsState.getLineWidth());
            for (LineChunk line : lines) {
                this.artifacts.add((IChunk)this.transformLineChunk(line, this.graphicsState.getCTM(), this.graphicsState.getLineWidth(), LineChunk.PROJECTING_SQUARE_CAP_STYLE));
            }
        }
        this.nonDrawingArtifacts = new LinkedList<Object>();
    }

    private void processf() {
        for (Object chunk : this.nonDrawingArtifacts) {
            LineChunk line;
            if (!(chunk instanceof Rectangle) || (line = ((Rectangle)chunk).getLine(0.0)) == null) continue;
            this.artifacts.add((IChunk)this.transformLineChunk(line, this.graphicsState.getCTM(), line.getWidth(), LineChunk.PROJECTING_SQUARE_CAP_STYLE));
        }
        this.nonDrawingArtifacts = new LinkedList<Object>();
    }

    private Double getValueOfLastNumber(List<COSBase> arguments) {
        COSBase base;
        if (!arguments.isEmpty() && (base = arguments.get(arguments.size() - 1)).getType().isNumber()) {
            return base.getReal();
        }
        return null;
    }

    private double[] parseImageBoundingBox() {
        double x1 = this.graphicsState.getCTM().getTranslateX() - this.cropBox[0];
        double y1 = this.graphicsState.getCTM().getTranslateY() - this.cropBox[1];
        double x2 = x1;
        double y2 = y1;
        if (this.graphicsState.getCTM().getScaleX() >= 0.0 && this.graphicsState.getCTM().getShearX() >= 0.0) {
            x2 += this.graphicsState.getCTM().getScaleX() + this.graphicsState.getCTM().getShearX();
        } else if (this.graphicsState.getCTM().getScaleX() < 0.0 && this.graphicsState.getCTM().getShearX() < 0.0) {
            x1 += this.graphicsState.getCTM().getScaleX() + this.graphicsState.getCTM().getShearX();
        } else if (this.graphicsState.getCTM().getScaleX() >= 0.0) {
            x1 += this.graphicsState.getCTM().getShearX();
            x2 += this.graphicsState.getCTM().getScaleX();
        } else {
            x1 += this.graphicsState.getCTM().getScaleX();
            x2 += this.graphicsState.getCTM().getShearX();
        }
        if (this.graphicsState.getCTM().getScaleY() >= 0.0 && this.graphicsState.getCTM().getShearY() >= 0.0) {
            y2 += this.graphicsState.getCTM().getScaleY() + this.graphicsState.getCTM().getShearY();
        } else if (this.graphicsState.getCTM().getScaleY() < 0.0 && this.graphicsState.getCTM().getShearY() < 0.0) {
            y1 += this.graphicsState.getCTM().getScaleY() + this.graphicsState.getCTM().getShearY();
        } else if (this.graphicsState.getCTM().getScaleY() >= 0.0) {
            y1 += this.graphicsState.getCTM().getShearY();
            y2 += this.graphicsState.getCTM().getScaleY();
        } else {
            y1 += this.graphicsState.getCTM().getScaleY();
            y2 += this.graphicsState.getCTM().getShearY();
        }
        return new double[]{x1, y1, x2, y2};
    }

    private void putChunk(Long mcid, IChunk chunk) {
        if (chunk == null) {
            return;
        }
        if (mcid != null) {
            StaticStorages.getChunks().add(this.pageObjectNumber, mcid, chunk);
        } else {
            this.artifacts.add(chunk);
        }
    }

    private COSBase getArgument(List<COSBase> arguments, String operatorType) {
        if ("\"".equals(operatorType)) {
            if (arguments.size() > 2) {
                return arguments.get(2);
            }
        } else if (!arguments.isEmpty()) {
            return arguments.get(0);
        }
        return null;
    }

    private void parseTextShowArgument(COSBase argument, StringBuilder unicodeValue, Matrix textRenderingMatrix) {
        if (argument.getType() == COSObjType.COS_STRING) {
            textRenderingMatrix.concatenate(this.calculateTextRenderingMatrix());
            this.parseString((COSString)argument.getDirectBase(), unicodeValue);
        } else if (argument.getType() == COSObjType.COS_ARRAY) {
            boolean beforeFirstText = true;
            COSArray array = (COSArray)argument;
            for (COSObject obj : array) {
                if (obj == null) continue;
                if (obj.getType() == COSObjType.COS_STRING) {
                    if (beforeFirstText) {
                        beforeFirstText = false;
                        textRenderingMatrix.concatenate(this.calculateTextRenderingMatrix());
                    }
                    this.parseString((COSString)obj.getDirectBase(), unicodeValue);
                    continue;
                }
                if (!obj.getType().isNumber()) continue;
                this.textMatrix.concatenate(Matrix.getTranslateInstance(-obj.getReal().doubleValue() / 1000.0 * this.graphicsState.getTextState().getTextFontSize() * this.graphicsState.getTextState().getHorizontalScaling(), 0.0));
            }
        }
    }

    private void parseString(COSString string, StringBuilder unicodeValue) {
        byte[] bytes = string.get();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            while (((InputStream)inputStream).available() > 0) {
                int code = this.graphicsState.getTextState().getTextFont().readCode((InputStream)inputStream);
                unicodeValue.append(this.graphicsState.getTextState().getTextFont().toUnicode(code));
                Double width = this.graphicsState.getTextState().getTextFont().getWidth(code);
                if (width == null) {
                    LOGGER.log(Level.SEVERE, "Missing width of glyph with code " + code + " in font" + this.graphicsState.getTextState().getTextFont().getName());
                    width = 0.0;
                }
                this.textMatrix.concatenate(Matrix.getTranslateInstance((width * this.graphicsState.getTextState().getTextFontSize() / 1000.0 + this.graphicsState.getTextState().getCharacterSpacing() + (code == 32 ? this.graphicsState.getTextState().getWordSpacing() : 0.0)) * this.graphicsState.getTextState().getHorizontalScaling(), 0.0));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error processing text show operator's string argument : " + new String(bytes), e);
        }
    }

    private TextChunk createTextChunk(List<COSBase> arguments, String operatorType) {
        PDFont font = this.graphicsState.getTextState().getTextFont();
        COSBase argument = this.getArgument(arguments, operatorType);
        if (font != null && argument != null && (argument.getType() == COSObjType.COS_STRING || argument.getType() == COSObjType.COS_ARRAY) && this.textMatrix != null) {
            StringBuilder unicodeValue = new StringBuilder();
            Matrix textRenderingMatrixBefore = new Matrix();
            this.parseTextShowArgument(argument, unicodeValue, textRenderingMatrixBefore);
            Matrix textRenderingMatrixAfter = this.calculateTextRenderingMatrix();
            return new TextChunk(new BoundingBox(this.pageNumber.intValue(), this.calculateTextBoundingBox(textRenderingMatrixBefore, textRenderingMatrixAfter, font.getBoundingBox())), unicodeValue.toString(), font.getNameWithoutSubset(), textRenderingMatrixAfter.getScaleY(), font.getFontWeight().doubleValue(), font.getFontDescriptor().getItalicAngle().doubleValue(), textRenderingMatrixAfter.getTranslateY() - this.cropBox[1], this.graphicsState.getFillColor(), this.graphicsState.getFillColorSpace() != null ? this.graphicsState.getFillColorSpace().getType().getValue() : null);
        }
        return null;
    }

    private Matrix calculateTextRenderingMatrix() {
        Matrix parameters = new Matrix(this.graphicsState.getTextState().getTextFontSize() * this.graphicsState.getTextState().getHorizontalScaling(), 0.0, 0.0, this.graphicsState.getTextState().getTextFontSize(), 0.0, this.graphicsState.getTextState().getTextRise());
        return parameters.multiply(this.textMatrix).multiply(this.graphicsState.getCTM());
    }

    private double[] calculateTextBoundingBox(Matrix textRenderingMatrixBefore, Matrix textRenderingMatrixAfter, double[] fontBoundingBox) {
        double y2;
        double y1;
        double x2;
        double x1;
        if (textRenderingMatrixBefore.getScaleX() >= 0.0 && textRenderingMatrixBefore.getShearX() >= 0.0) {
            x1 = textRenderingMatrixBefore.getTranslateX() + fontBoundingBox[1] * textRenderingMatrixBefore.getShearX() / 1000.0;
            x2 = textRenderingMatrixAfter.getTranslateX() + fontBoundingBox[3] * textRenderingMatrixAfter.getShearX() / 1000.0;
        } else if (textRenderingMatrixBefore.getScaleX() < 0.0 && textRenderingMatrixBefore.getShearX() < 0.0) {
            x1 = textRenderingMatrixAfter.getTranslateX() + fontBoundingBox[3] * textRenderingMatrixAfter.getShearX() / 1000.0;
            x2 = textRenderingMatrixBefore.getTranslateX() + fontBoundingBox[1] * textRenderingMatrixBefore.getShearX() / 1000.0;
        } else if (textRenderingMatrixBefore.getScaleX() >= 0.0) {
            x1 = textRenderingMatrixBefore.getTranslateX() + fontBoundingBox[3] * textRenderingMatrixBefore.getShearX() / 1000.0;
            x2 = textRenderingMatrixAfter.getTranslateX() + fontBoundingBox[1] * textRenderingMatrixAfter.getShearX() / 1000.0;
        } else {
            x1 = textRenderingMatrixAfter.getTranslateX() + fontBoundingBox[1] * textRenderingMatrixAfter.getShearX() / 1000.0;
            x2 = textRenderingMatrixBefore.getTranslateX() + fontBoundingBox[3] * textRenderingMatrixBefore.getShearX() / 1000.0;
        }
        if (textRenderingMatrixBefore.getScaleY() >= 0.0 && textRenderingMatrixBefore.getShearY() >= 0.0) {
            y1 = textRenderingMatrixBefore.getTranslateY() + fontBoundingBox[1] * textRenderingMatrixBefore.getScaleY() / 1000.0;
            y2 = textRenderingMatrixAfter.getTranslateY() + fontBoundingBox[3] * textRenderingMatrixAfter.getScaleY() / 1000.0;
        } else if (textRenderingMatrixBefore.getScaleY() < 0.0 && textRenderingMatrixBefore.getShearY() < 0.0) {
            y1 = textRenderingMatrixAfter.getTranslateY() + fontBoundingBox[3] * textRenderingMatrixAfter.getScaleY() / 1000.0;
            y2 = textRenderingMatrixBefore.getTranslateY() + fontBoundingBox[1] * textRenderingMatrixBefore.getScaleY() / 1000.0;
        } else if (textRenderingMatrixBefore.getScaleY() >= 0.0) {
            y1 = textRenderingMatrixAfter.getTranslateY() + fontBoundingBox[1] * textRenderingMatrixAfter.getScaleY() / 1000.0;
            y2 = textRenderingMatrixBefore.getTranslateY() + fontBoundingBox[3] * textRenderingMatrixBefore.getScaleY() / 1000.0;
        } else {
            y1 = textRenderingMatrixBefore.getTranslateY() + fontBoundingBox[3] * textRenderingMatrixBefore.getScaleY() / 1000.0;
            y2 = textRenderingMatrixAfter.getTranslateY() + fontBoundingBox[1] * textRenderingMatrixAfter.getScaleY() / 1000.0;
        }
        return new double[]{x1 - this.cropBox[0], y1 - this.cropBox[1], x2 - this.cropBox[0], y2 - this.cropBox[1]};
    }

    private Long getMarkedContent() {
        if (!this.markedContentStack.empty()) {
            for (int i = this.markedContentStack.size() - 1; i >= 0; --i) {
                Long mcid = (Long)this.markedContentStack.get(i);
                if (mcid == null) continue;
                return mcid;
            }
        }
        return null;
    }

    private Long getMCID(List<COSBase> arguments, ResourceHandler resources) {
        if (!arguments.isEmpty()) {
            COSBase cosProperties;
            PDResource properties;
            COSBase lastArg = arguments.get(arguments.size() - 1);
            if (lastArg.getType() == COSObjType.COS_DICT) {
                return lastArg.getIntegerKey(ASAtom.MCID);
            }
            if (lastArg.getType() == COSObjType.COS_NAME && resources != null && (properties = resources.getProperties(lastArg.getName())) != null && (cosProperties = properties.getObject().getDirectBase()) != null && cosProperties.getType() == COSObjType.COS_DICT) {
                return cosProperties.getIntegerKey(ASAtom.MCID);
            }
        }
        return null;
    }

    private LineChunk transformLineChunk(LineChunk lineChunk, Matrix currentTransformationMatrix, double lineWidth, int lineCap) {
        return LineChunk.createLineChunk((Integer)this.pageNumber, (double)(lineChunk.getStartX() * currentTransformationMatrix.getScaleX() + lineChunk.getStartY() * currentTransformationMatrix.getShearY() + currentTransformationMatrix.getTranslateX()), (double)(lineChunk.getStartX() * currentTransformationMatrix.getShearX() + lineChunk.getStartY() * currentTransformationMatrix.getScaleY() + currentTransformationMatrix.getTranslateY()), (double)(lineChunk.getEndX() * currentTransformationMatrix.getScaleX() + lineChunk.getEndY() * currentTransformationMatrix.getShearY() + currentTransformationMatrix.getTranslateX()), (double)(lineChunk.getEndX() * currentTransformationMatrix.getShearX() + lineChunk.getEndY() * currentTransformationMatrix.getScaleY() + currentTransformationMatrix.getTranslateY()), (double)lineWidth, (int)lineCap);
    }

    private static void processColorSpace(GraphicsState graphicState, ResourceHandler resourcesHandler, PDColorSpace defaultCS, ASAtom name, boolean stroke) {
        PDColorSpace colorSpace = resourcesHandler.getColorSpace(name);
        if (colorSpace == null) {
            colorSpace = defaultCS;
        }
        if (!stroke) {
            graphicState.setFillColorSpace(colorSpace);
        }
    }

    private boolean isProcessColorSpace(ASAtom colorSpaceType) {
        return ASAtom.DEVICERGB.equals((Object)colorSpaceType) || ASAtom.DEVICEGRAY.equals((Object)colorSpaceType) || ASAtom.DEVICECMYK.equals((Object)colorSpaceType) || ASAtom.ICCBASED.equals((Object)colorSpaceType) || ASAtom.CALRGB.equals((Object)colorSpaceType) || ASAtom.CALGRAY.equals((Object)colorSpaceType);
    }
}

