/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.sa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.gf.model.impl.sa.GFSAAnnotation;
import org.verapdf.gf.model.impl.sa.GFSAContentStream;
import org.verapdf.gf.model.impl.sa.GFSAImageChunk;
import org.verapdf.gf.model.impl.sa.GFSATextChunk;
import org.verapdf.gf.model.impl.sa.util.ResourceHandler;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.salayer.SAAnnotation;
import org.verapdf.model.salayer.SAChunk;
import org.verapdf.model.salayer.SAPage;
import org.verapdf.pd.PDAnnotation;
import org.verapdf.pd.PDPage;
import org.verapdf.wcag.algorithms.entities.IPage;
import org.verapdf.wcag.algorithms.entities.content.IChunk;
import org.verapdf.wcag.algorithms.entities.content.ImageChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;

public class GFSAPage
extends GenericModelObject
implements SAPage,
IPage {
    public static final String PAGE_TYPE = "SAPage";
    public static final String ARTIFACTS = "artifacts";
    private static final String ANNOTS = "annots";
    private GFSAContentStream contentStream = null;
    private List<SAChunk> artifacts = null;
    private final PDPage pdPage;
    private List<SAAnnotation> annotations = null;

    public GFSAPage(PDPage pdPage) {
        super(PAGE_TYPE);
        this.pdPage = pdPage;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "artifacts": {
                return this.getartifacts();
            }
            case "annots": {
                return this.getAnnotations();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<SAAnnotation> parseAnnotataions() {
        List annots = this.pdPage.getAnnotations();
        if (annots.size() > 0) {
            ArrayList<GFSAAnnotation> res = new ArrayList<GFSAAnnotation>(annots.size());
            for (PDAnnotation annot : annots) {
                res.add(GFSAAnnotation.createAnnot(annot, this.pdPage));
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private List<SAAnnotation> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.parseAnnotataions();
        }
        return this.annotations;
    }

    private List<SAChunk> getartifacts() {
        if (this.artifacts == null) {
            List<IChunk> artifacts = this.getArtifacts();
            this.artifacts = new ArrayList<SAChunk>(artifacts.size());
            for (IChunk chunk : artifacts) {
                if (chunk instanceof TextChunk) {
                    this.artifacts.add(new GFSATextChunk((TextChunk)chunk));
                    continue;
                }
                if (!(chunk instanceof ImageChunk)) continue;
                this.artifacts.add(new GFSAImageChunk((ImageChunk)chunk));
            }
        }
        return this.artifacts;
    }

    public List<IChunk> getArtifacts() {
        if (this.contentStream == null) {
            this.parseContentStream();
        }
        if (this.contentStream != null) {
            return this.contentStream.getArtifacts();
        }
        return Collections.emptyList();
    }

    public GFSAContentStream getContentStream() {
        if (this.contentStream == null) {
            this.parseContentStream();
        }
        return this.contentStream;
    }

    private void parseContentStream() {
        GFSAContentStream pdContentStream = null;
        if (this.pdPage.getContent() != null) {
            ResourceHandler resourceHandler = ResourceHandler.getInstance(this.pdPage.getResources());
            pdContentStream = new GFSAContentStream(this.pdPage.getContent(), resourceHandler, this.pdPage.getPageNumber(), this.pdPage.getObject().getKey(), this.pdPage.getCropBox());
        }
        this.contentStream = pdContentStream;
    }

    public int getPageNumber() {
        return this.pdPage.getPageNumber();
    }
}

