/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.containers;

import java.util.Map;
import org.verapdf.as.ASAtom;
import org.verapdf.gf.model.factory.chunks.ChunkContainer;
import org.verapdf.tools.TaggedPDFRoleMapHelper;

public class StaticStorages {
    private static final ThreadLocal<TaggedPDFRoleMapHelper> roleMapHelper = new ThreadLocal();
    private static final ThreadLocal<ChunkContainer> chunks = new ThreadLocal();

    public static void clearAllContainers() {
        roleMapHelper.set(null);
        chunks.set(new ChunkContainer());
    }

    public static TaggedPDFRoleMapHelper getRoleMapHelper() {
        return roleMapHelper.get();
    }

    public static void setRoleMapHelper(Map<ASAtom, ASAtom> roleMap) {
        roleMapHelper.set(new TaggedPDFRoleMapHelper(roleMap));
    }

    public static void setRoleMapHelper(TaggedPDFRoleMapHelper roleMapHelper) {
        StaticStorages.roleMapHelper.set(roleMapHelper);
    }

    public static ChunkContainer getChunks() {
        if (chunks.get() == null) {
            chunks.set(new ChunkContainer());
        }
        return chunks.get();
    }

    public static void setChunks(ChunkContainer chunks) {
        StaticStorages.chunks.set(chunks);
    }
}

