/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.sa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.containers.StaticStorages;
import org.verapdf.gf.model.impl.sa.GFSAImageChunk;
import org.verapdf.gf.model.impl.sa.GFSALineArtChunk;
import org.verapdf.gf.model.impl.sa.GFSANode;
import org.verapdf.gf.model.impl.sa.GFSATextChunk;
import org.verapdf.gf.model.impl.sa.structelems.GFSAFactory;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.salayer.SAStructElem;
import org.verapdf.pd.structure.PDMCRDictionary;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.SemanticFigure;
import org.verapdf.wcag.algorithms.entities.SemanticImageNode;
import org.verapdf.wcag.algorithms.entities.SemanticSpan;
import org.verapdf.wcag.algorithms.entities.content.IChunk;
import org.verapdf.wcag.algorithms.entities.content.ImageChunk;
import org.verapdf.wcag.algorithms.entities.content.LineArtChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TextChunkUtils;

public class GFSAStructElem
extends GenericModelObject
implements SAStructElem {
    public static final String CHILDREN = "children";
    protected final PDStructElem structElemDictionary;
    protected List<org.verapdf.model.baselayer.Object> children = null;
    private INode node;
    private final String id;
    private final String standardType;
    private final StringBuilder textValue = new StringBuilder();
    private final boolean isTableChild;
    private final boolean isListChild;
    private boolean isLeafNode = true;
    private final String parentsStandardTypes;

    public GFSAStructElem(PDStructElem structElemDictionary, String standardType, String type, String parentsStandardTypes) {
        super(type);
        this.structElemDictionary = structElemDictionary;
        this.standardType = standardType;
        COSKey key = structElemDictionary.getObject().getObjectKey();
        this.id = (key != null ? key.getNumber() + " " + key.getGeneration() : "0 0") + " obj" + (standardType != null ? " " + standardType : "") + (this.getStructureType() != null ? " " + ((COSName)COSName.fromValue((String)this.getStructureType())).getUnicodeValue() : "");
        this.isTableChild = Arrays.asList(parentsStandardTypes.split("&")).contains("Table");
        this.isListChild = Arrays.asList(parentsStandardTypes.split("&")).contains("L");
        this.parentsStandardTypes = parentsStandardTypes;
    }

    public void setNode(INode node) {
        this.node = node;
    }

    public INode getNode() {
        return this.node;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "children": {
                return this.getChildren();
            }
        }
        return super.getLinkedObjects(link);
    }

    public String getType() {
        ASAtom type = this.structElemDictionary.getType();
        return type == null ? null : type.getValue();
    }

    public String getStructureType() {
        ASAtom subtype = this.structElemDictionary.getNameKey(ASAtom.S);
        return subtype == null ? null : subtype.getValue();
    }

    public String getstandardType() {
        return this.standardType;
    }

    public Boolean getisTableElem() {
        return "TBody".equals(this.standardType) || "THead".equals(this.standardType) || "TFoot".equals(this.standardType) || "TH".equals(this.standardType) || "TD".equals(this.standardType) || "TR".equals(this.standardType);
    }

    public Boolean getisListElem() {
        return "L".equals(this.standardType) || "LI".equals(this.standardType) || "LBody".equals(this.standardType) || "Lbl".equals(this.standardType);
    }

    public Boolean getisTableChild() {
        return this.isTableChild;
    }

    public Boolean getisListChild() {
        return this.isListChild;
    }

    public Boolean getisLeafElem() {
        if (this.children == null) {
            this.parseChildren();
        }
        return this.isLeafNode;
    }

    public Long getstructureID() {
        return this.node.getRecognizedStructureId();
    }

    public List<org.verapdf.model.baselayer.Object> getChildren() {
        if (this.children == null) {
            this.parseChildren();
        }
        return Collections.unmodifiableList(this.children);
    }

    protected void parseChildren() {
        List elements = this.structElemDictionary.getChildren();
        this.children = new ArrayList<org.verapdf.model.baselayer.Object>(elements.size());
        if (!elements.isEmpty()) {
            LinkedList<IChunk> chunks = new LinkedList<IChunk>();
            for (Object element : elements) {
                if (element instanceof PDStructElem) {
                    this.addChunksToChildren(chunks);
                    GFSAStructElem structElem = GFSAFactory.createTypedStructElem((PDStructElem)element, (this.parentsStandardTypes.isEmpty() ? "" : this.parentsStandardTypes + "&") + this.standardType);
                    GFSANode childNode = new GFSANode(structElem);
                    structElem.setNode((INode)childNode);
                    this.node.addChild((INode)childNode);
                    this.children.add((org.verapdf.model.baselayer.Object)structElem);
                    this.isLeafNode = false;
                    continue;
                }
                if (element instanceof PDMCRDictionary) {
                    PDMCRDictionary mcr = (PDMCRDictionary)element;
                    COSKey streamKey = mcr.getStreamObjectKey();
                    if (streamKey != null) {
                        chunks.addAll(this.getChunks(streamKey, mcr.getMCID()));
                        continue;
                    }
                    chunks.addAll(this.getChunks(mcr.getPageObjectKey(), mcr.getMCID()));
                    continue;
                }
                if (!(element instanceof COSObject) || ((COSObject)element).getType() != COSObjType.COS_INTEGER) continue;
                chunks.addAll(this.getChunks(this.getPageObjectNumber(), ((COSObject)element).getDirectBase().getInteger()));
            }
            this.addChunksToChildren(chunks);
        }
    }

    private List<IChunk> getChunks(COSKey objectNumber, Long mcid) {
        List<IChunk> chunks = StaticStorages.getChunks().get(objectNumber, mcid);
        return chunks != null ? chunks : Collections.emptyList();
    }

    private void addChunksToChildren(List<IChunk> chunks) {
        for (int i = 0; i < chunks.size(); ++i) {
            IChunk chunk = chunks.get(i);
            if (chunk instanceof TextChunk) {
                i += this.addTextChunk(i, chunks);
                continue;
            }
            if (chunk instanceof ImageChunk) {
                this.node.addChild((INode)new SemanticImageNode((ImageChunk)chunk));
                this.children.add((org.verapdf.model.baselayer.Object)new GFSAImageChunk((ImageChunk)chunk));
                continue;
            }
            if (!(chunk instanceof LineArtChunk)) continue;
            this.node.addChild((INode)new SemanticFigure((LineArtChunk)chunk));
            this.children.add((org.verapdf.model.baselayer.Object)new GFSALineArtChunk((LineArtChunk)chunk));
        }
        chunks.clear();
    }

    public int addTextChunk(int number, List<IChunk> chunks) {
        TextChunk nextTextChunk;
        int i;
        TextChunk textChunk = (TextChunk)chunks.get(number);
        for (i = number + 1; i < chunks.size() && chunks.get(i) instanceof TextChunk && TextChunkUtils.areTextChunksHaveSameStyle((TextChunk)textChunk, (TextChunk)(nextTextChunk = (TextChunk)chunks.get(i))) && TextChunkUtils.areTextChunksHaveSameBaseLine((TextChunk)textChunk, (TextChunk)nextTextChunk) && TextChunkUtils.areNeighborsTextChunks((TextChunk)textChunk, (TextChunk)nextTextChunk); ++i) {
            textChunk = TextChunkUtils.unionTextChunks((TextChunk)textChunk, (TextChunk)nextTextChunk);
        }
        this.textValue.append(textChunk.getValue());
        this.node.addChild((INode)new SemanticSpan(textChunk));
        this.children.add((org.verapdf.model.baselayer.Object)new GFSATextChunk(textChunk, (this.parentsStandardTypes.isEmpty() ? "" : this.parentsStandardTypes + "&") + this.getstandardType()));
        return i - number - 1;
    }

    public String getContext() {
        return this.node.getBoundingBox().getLocation();
    }

    public Double getcorrectSemanticScore() {
        return this.node.getCorrectSemanticScore();
    }

    public String getvalueS() {
        COSName type = this.structElemDictionary.getCOSStructureType();
        return type != null ? type.getString() : null;
    }

    public String getcorrectType() {
        SemanticType semanticType = this.node.getSemanticType();
        if (semanticType == null) {
            return null;
        }
        return semanticType.getValue();
    }

    public String getID() {
        return this.id;
    }

    public COSKey getPageObjectNumber() {
        return this.structElemDictionary.getPageObjectNumber();
    }

    public String getparentsStandardTypes() {
        return this.parentsStandardTypes;
    }

    public String getkidsStandardTypes() {
        return this.getChildrenStandardTypes().stream().filter(type -> type != null && !"Artifact".equals(type)).collect(Collectors.joining("&"));
    }

    private List<String> getChildrenStandardTypes() {
        return GFSAStructElem.getChildrenStandardTypes(this);
    }

    private static List<String> getChildrenStandardTypes(GFSAStructElem element) {
        if (element.children == null) {
            element.parseChildren();
        }
        ArrayList<String> res = new ArrayList<String>();
        for (org.verapdf.model.baselayer.Object child : element.children) {
            if (!(child instanceof GFSAStructElem)) continue;
            String elementStandardType = ((GFSAStructElem)child).getstandardType();
            if ("NonStruct".equals(elementStandardType)) {
                res.addAll(GFSAStructElem.getChildrenStandardTypes((GFSAStructElem)child));
                continue;
            }
            res.add(elementStandardType);
        }
        return Collections.unmodifiableList(res);
    }

    public String getparentStandardType() {
        PDStructElem parent = this.structElemDictionary.getParent();
        if (parent != null) {
            String parentStandardType = GFSAFactory.getStructureElementStandardType(parent);
            while ("NonStruct".equals(parentStandardType)) {
                if ((parent = parent.getParent()) == null) {
                    return null;
                }
                parentStandardType = GFSAFactory.getStructureElementStandardType(parent);
            }
            return parentStandardType;
        }
        return null;
    }

    public String getTextValue() {
        if (this.children == null) {
            this.parseChildren();
        }
        return this.textValue.toString();
    }

    public Boolean gethasLowestDepthError() {
        return this.node.getHasLowestDepthError();
    }

    public Long getpage() {
        Integer page = this.node.getBoundingBox().getPageNumber();
        if (page != null) {
            return (long)page;
        }
        return null;
    }

    public Long getlastPage() {
        Integer lastPage = this.node.getBoundingBox().getLastPageNumber();
        if (lastPage != null) {
            return (long)lastPage;
        }
        return null;
    }
}

