/*
 * Copyright (C) 2024-present Verifyica project authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.verifyica.api;

/** Interface to implement EngineInterceptor */
public interface EngineInterceptor {

    /**
     * Engine initialize callback
     *
     * @param engineContext engineContext
     * @throws Throwable Throwable
     */
    default void initialize(EngineContext engineContext) throws Throwable {
        // INTENTIONALLY BLANK
    }

    /**
     * Engine destroy callback
     *
     * @param engineContext engineContext
     * @throws Throwable Throwable
     */
    default void destroy(EngineContext engineContext) throws Throwable {
        // INTENTIONALLY BLANK
    }
}
