/*
 * Copyright (C) Verifyica project authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.verifyica.api;

/**
 * Utility class to provide a class scoped string representation of an Enum value.
 */
public class EnumKey {

    /**
     * Constructor
     */
    private EnumKey() {
        // INTENTIONALLY BLANK
    }

    /**
     * Get the enum key as a class scoped string representation.
     *
     * @param value the enum value
     * @return the class scoped string representation of the enum
     */
    public static String of(Enum<?> value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }

        return value.getDeclaringClass().getName() + "." + value.name();
    }
}
