/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.api;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Cleanup {
    private final List<Throwable> throwables = new ArrayList<Throwable>();

    public Cleanup perform(Action action) {
        try {
            action.perform();
        }
        catch (Throwable t) {
            this.throwables.add(t);
        }
        return this;
    }

    public Cleanup perform(Action ... actions) {
        for (Action action : actions) {
            this.perform(action);
        }
        return this;
    }

    public Cleanup close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                this.throwables.add(t);
            }
        }
        return this;
    }

    public Cleanup close(Closeable ... closeables) {
        if (closeables != null) {
            for (Closeable closeable : closeables) {
                this.close(closeable);
            }
        }
        return this;
    }

    public boolean isEmpty() {
        return this.throwables.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public List<Throwable> getThrowables() {
        return this.throwables;
    }

    public Optional<Throwable> getFirst() {
        return this.throwables.isEmpty() ? Optional.empty() : Optional.of(this.throwables.get(0));
    }

    public Cleanup assertEmpty() throws Throwable {
        if (this.isNotEmpty()) {
            throw this.throwables.get(0);
        }
        return this;
    }

    public Cleanup clear() {
        this.throwables.clear();
        return this;
    }

    public static interface Action {
        public void perform() throws Throwable;
    }
}

