/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.api;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.verifyica.api.Named;

public interface Argument<T>
extends Named {
    public static final Argument<Object> EMPTY = new Empty();

    @Override
    public String getName();

    public T getPayload();

    default public <V> V getPayload(Class<V> type) {
        Argument.notNull(type, "type is null");
        return type.cast(this.getPayload());
    }

    default public boolean hasPayload() {
        return this.getPayload() != null;
    }

    public static Argument<Boolean> ofBoolean(boolean value) {
        return Argument.of(String.valueOf(value), value);
    }

    public static Argument<Byte> ofByte(byte value) {
        return Argument.of(String.valueOf(value), value);
    }

    public static Argument<Character> ofChar(char value) {
        return Argument.of(String.valueOf(value), Character.valueOf(value));
    }

    public static Argument<Short> ofShort(short value) {
        return Argument.of(String.valueOf(value), value);
    }

    public static Argument<Integer> ofInt(int value) {
        return Argument.of(String.valueOf(value), value);
    }

    public static Argument<Long> ofLong(long value) {
        return Argument.of(String.valueOf(value), value);
    }

    public static Argument<Float> ofFloat(float value) {
        return Argument.of(String.valueOf(value), Float.valueOf(value));
    }

    public static Argument<Double> ofDouble(double value) {
        return Argument.of(String.valueOf(value), value);
    }

    public static Argument<String> ofString(String value) {
        if (value == null) {
            return Argument.of("String=/null/", null);
        }
        if (value.isEmpty()) {
            return Argument.of("String=/empty/", "");
        }
        return Argument.of(value, value);
    }

    public static Argument<BigInteger> ofBigInteger(BigInteger value) {
        if (value == null) {
            return Argument.of("BigInteger=/null/", null);
        }
        return Argument.of(value.toString(), value);
    }

    public static Argument<BigDecimal> ofBigDecimal(BigDecimal value) {
        if (value == null) {
            return Argument.of("BigDecimal=/null/", null);
        }
        return Argument.of(value.toString(), value);
    }

    public static <T> Argument<T> of(final String name, final T payload) {
        Argument.notBlank(name, "name is null", "name is blank");
        return new Argument<T>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public T getPayload() {
                return payload;
            }

            public String toString() {
                return name;
            }
        };
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notBlank(String string, String nullMessage, String blankMessage) {
        if (string == null) {
            throw new IllegalArgumentException(nullMessage);
        }
        if (string.trim().isEmpty()) {
            throw new IllegalArgumentException(blankMessage);
        }
    }

    public static class Empty
    implements Argument<Object> {
        private final String NAME = "---";

        private Empty() {
        }

        @Override
        public String getName() {
            return "---";
        }

        @Override
        public Object getPayload() {
            return null;
        }

        @Override
        public <V> V getPayload(Class<V> type) {
            Argument.notNull(type, "type is null");
            return type.cast(null);
        }

        @Override
        public boolean hasPayload() {
            return false;
        }

        public String toString() {
            return "---";
        }
    }
}

