/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.api;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class Runner {
    private final List<Throwable> throwables = new ArrayList<Throwable>();

    public Runner perform(Task task) {
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        try {
            task.perform();
        }
        catch (Throwable t) {
            this.throwables.add(t);
        }
        return this;
    }

    public Runner perform(Task ... tasks) {
        if (tasks == null) {
            throw new IllegalArgumentException("tasks is null");
        }
        if (tasks.length == 0) {
            throw new IllegalArgumentException("tasks is empty");
        }
        for (int i = 0; i < tasks.length; ++i) {
            Task task = tasks[i];
            if (task == null) {
                throw new IllegalArgumentException(String.format("tasks[%d] is null", i));
            }
            try {
                task.perform();
                continue;
            }
            catch (Throwable t) {
                this.throwables.add(t);
            }
        }
        return this;
    }

    public Runner perform(Collection<Task> tasks) {
        if (tasks == null) {
            throw new IllegalArgumentException("tasks is null");
        }
        if (tasks.isEmpty()) {
            throw new IllegalArgumentException("tasks is empty");
        }
        int i = 0;
        for (Task task : tasks) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("tasks(%d) is null", i));
            }
            try {
                task.perform();
            }
            catch (Throwable t) {
                this.throwables.add(t);
            }
            ++i;
        }
        return this;
    }

    public boolean isEmpty() {
        return this.throwables.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public List<Throwable> throwables() {
        return this.throwables;
    }

    public Optional<Throwable> firstThrowable() {
        return this.throwables.isEmpty() ? Optional.empty() : Optional.of(this.throwables.get(0));
    }

    public Runner assertSuccessful() throws Throwable {
        if (this.isNotEmpty()) {
            throw this.throwables.get(0);
        }
        return this;
    }

    public Runner clear() {
        this.throwables.clear();
        return this;
    }

    public static Task closeTask(Closeable closeable) {
        return () -> {
            if (closeable != null) {
                closeable.close();
            }
        };
    }

    public static interface Task {
        public void perform() throws Throwable;
    }
}

