/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.api;

import java.util.Collection;
import java.util.Optional;

public class Trap {
    private Throwable throwable;

    public Trap(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable is null");
        }
        try {
            runnable.run();
        }
        catch (Throwable t) {
            this.throwable = t;
        }
    }

    public Optional<Throwable> throwable() {
        return Optional.ofNullable(this.throwable);
    }

    public boolean isEmpty() {
        return this.throwable == null;
    }

    public void assertEmpty() throws Throwable {
        if (this.throwable != null) {
            throw this.throwable;
        }
    }

    public static void assertEmpty(Trap trap) throws Throwable {
        if (trap == null) {
            throw new IllegalArgumentException("trap is null");
        }
        trap.assertEmpty();
    }

    public static void assertEmpty(Trap ... traps) throws Throwable {
        if (traps == null) {
            throw new IllegalArgumentException("traps is null");
        }
        int i = 0;
        for (Trap trap : traps) {
            if (trap == null) {
                throw new IllegalArgumentException(String.format("traps[%d] is null", i));
            }
            ++i;
        }
        for (Trap trap : traps) {
            trap.assertEmpty();
        }
    }

    public static void assertEmpty(Collection<Trap> traps) throws Throwable {
        if (traps == null) {
            throw new IllegalArgumentException("traps is null");
        }
        for (Trap trap : traps) {
            trap.assertEmpty();
        }
    }

    public static interface Runnable {
        public void run() throws Throwable;
    }
}

