/*
 * Copyright (C) 2024-present Verifyica project authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.verifyica.api;

/** Interface to implement EngineContext */
public interface EngineContext extends Context {

    /**
     * Get the Engine version
     *
     * @return the Engine version
     */
    default String version() {
        return getVersion();
    }

    /**
     * Get the Engine Configuration
     *
     * @return the Engine Configuration
     */
    default Configuration configuration() {
        return getConfiguration();
    }

    /**
     * Get the Engine version
     *
     * @return the Engine version
     */
    String getVersion();

    /**
     * Get the Engine Configuration
     *
     * @return the Engine Configuration
     */
    Configuration getConfiguration();
}
