/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.api;

import java.util.function.BooleanSupplier;

public class Execution {
    private Execution() {
    }

    public static void skipIfCondition(boolean condition) throws ExecutionSkippedException {
        Execution.skipIfCondition(condition, null);
    }

    public static void skipIfCondition(boolean condition, String message) throws ExecutionSkippedException {
        if (condition) {
            if (message == null || message.trim().isEmpty()) {
                throw new ExecutionSkippedException();
            }
            throw new ExecutionSkippedException(message);
        }
    }

    public static void skipIfCondition(BooleanSupplier supplier) throws ExecutionSkippedException {
        if (supplier == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        Execution.skipIfCondition(supplier.getAsBoolean(), null);
    }

    public static void skipIfCondition(BooleanSupplier supplier, String message) throws ExecutionSkippedException {
        if (supplier == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        Execution.skipIfCondition(supplier.getAsBoolean(), message);
    }

    public static void skipIfNotCondition(boolean condition) throws ExecutionSkippedException {
        Execution.skipIfNotCondition(condition, null);
    }

    public static void skipIfNotCondition(boolean condition, String message) throws ExecutionSkippedException {
        if (!condition) {
            if (message == null || message.trim().isEmpty()) {
                throw new ExecutionSkippedException();
            }
            throw new ExecutionSkippedException(message);
        }
    }

    public static void skipIfNotCondition(BooleanSupplier supplier) throws ExecutionSkippedException {
        if (supplier == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        Execution.skipIfNotCondition(supplier.getAsBoolean(), null);
    }

    public static void skipIfNotCondition(BooleanSupplier supplier, String message) throws ExecutionSkippedException {
        if (supplier == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        Execution.skipIfNotCondition(supplier.getAsBoolean(), message);
    }

    public static class ExecutionSkippedException
    extends RuntimeException {
        public ExecutionSkippedException() {
        }

        public ExecutionSkippedException(String message) {
            super(message);
        }
    }
}

