/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.api;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;

public class TemporaryDirectory
implements AutoCloseable {
    private static final String DEFAULT_PREFIX = "verifyica-temp-";
    private final Path temporaryDirectory;

    public TemporaryDirectory() throws IOException {
        this(DEFAULT_PREFIX);
    }

    public TemporaryDirectory(String prefix) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix is null");
        }
        if (prefix.trim().isEmpty()) {
            throw new IllegalArgumentException("prefix is blank");
        }
        this.temporaryDirectory = Files.createTempDirectory(prefix.trim() + UUID.randomUUID(), new FileAttribute[0]);
    }

    public Path path() {
        return this.getPath();
    }

    public Path getPath() {
        return this.temporaryDirectory;
    }

    @Override
    public void close() throws IOException {
        this.deleteRecursively(this.temporaryDirectory);
    }

    private void deleteRecursively(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

