/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.blueprints;

import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.GraphQuery;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.vertexium.Visibility;
import org.vertexium.blueprints.AuthorizationsProvider;
import org.vertexium.blueprints.VertexiumBlueprintsConvert;
import org.vertexium.blueprints.VertexiumBlueprintsEdge;
import org.vertexium.blueprints.VertexiumBlueprintsGraphFeatures;
import org.vertexium.blueprints.VertexiumBlueprintsGraphQuery;
import org.vertexium.blueprints.VertexiumBlueprintsVertex;
import org.vertexium.blueprints.VisibilityProvider;
import org.vertexium.query.Compare;
import org.vertexium.query.Predicate;
import org.vertexium.util.ConvertingIterable;

public abstract class VertexiumBlueprintsGraph
implements com.tinkerpop.blueprints.Graph {
    private static final VertexiumBlueprintsGraphFeatures FEATURES = new VertexiumBlueprintsGraphFeatures();
    private final Graph vertexiumGraph;
    private final VisibilityProvider visibilityProvider;
    private final AuthorizationsProvider authorizationsProvider;

    protected VertexiumBlueprintsGraph(Graph vertexiumGraph, VisibilityProvider visibilityProvider, AuthorizationsProvider authorizationsProvider) {
        this.vertexiumGraph = vertexiumGraph;
        this.visibilityProvider = visibilityProvider;
        this.authorizationsProvider = authorizationsProvider;
    }

    public Features getFeatures() {
        return FEATURES;
    }

    public com.tinkerpop.blueprints.Vertex addVertex(Object id) {
        Visibility visibility = this.getVisibilityProvider().getVisibilityForVertex(VertexiumBlueprintsConvert.idToString(id));
        Authorizations authorizations = this.getAuthorizationsProvider().getAuthorizations();
        return VertexiumBlueprintsVertex.create(this, this.getGraph().addVertex(VertexiumBlueprintsConvert.idToString(id), visibility, authorizations), authorizations);
    }

    public com.tinkerpop.blueprints.Vertex getVertex(Object id) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Authorizations authorizations = this.getAuthorizationsProvider().getAuthorizations();
        return VertexiumBlueprintsVertex.create(this, this.getGraph().getVertex(VertexiumBlueprintsConvert.idToString(id), authorizations), authorizations);
    }

    public void removeVertex(com.tinkerpop.blueprints.Vertex vertex) {
        Vertex sgVertex = VertexiumBlueprintsConvert.toVertexium(vertex);
        this.getGraph().deleteVertex(sgVertex, this.getAuthorizationsProvider().getAuthorizations());
    }

    public Iterable<com.tinkerpop.blueprints.Vertex> getVertices() {
        final Authorizations authorizations = this.getAuthorizationsProvider().getAuthorizations();
        return new ConvertingIterable<Vertex, com.tinkerpop.blueprints.Vertex>(this.getGraph().getVertices(authorizations)){

            protected com.tinkerpop.blueprints.Vertex convert(Vertex vertex) {
                return VertexiumBlueprintsVertex.create(VertexiumBlueprintsGraph.this, vertex, authorizations);
            }
        };
    }

    public Iterable<com.tinkerpop.blueprints.Vertex> getVertices(String key, Object value) {
        final Authorizations authorizations = this.getAuthorizationsProvider().getAuthorizations();
        return new ConvertingIterable<Vertex, com.tinkerpop.blueprints.Vertex>(this.getGraph().query(authorizations).has(key, (Predicate)Compare.EQUAL, value).vertices()){

            protected com.tinkerpop.blueprints.Vertex convert(Vertex vertex) {
                return VertexiumBlueprintsVertex.create(VertexiumBlueprintsGraph.this, vertex, authorizations);
            }
        };
    }

    public com.tinkerpop.blueprints.Edge addEdge(Object id, com.tinkerpop.blueprints.Vertex outVertex, com.tinkerpop.blueprints.Vertex inVertex, String label) {
        if (label == null) {
            throw new IllegalArgumentException("label cannot be null");
        }
        Vertex sgOutVertex = VertexiumBlueprintsConvert.toVertexium(outVertex);
        Vertex sgInVertex = VertexiumBlueprintsConvert.toVertexium(inVertex);
        Visibility visibility = this.getVisibilityProvider().getVisibilityForEdge(VertexiumBlueprintsConvert.idToString(id), sgOutVertex, sgInVertex, label);
        Authorizations authorizations = this.getAuthorizationsProvider().getAuthorizations();
        return VertexiumBlueprintsEdge.create(this, this.getGraph().addEdge(VertexiumBlueprintsConvert.idToString(id), sgOutVertex, sgInVertex, label, visibility, authorizations), authorizations);
    }

    public com.tinkerpop.blueprints.Edge getEdge(Object id) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Authorizations authorizations = this.getAuthorizationsProvider().getAuthorizations();
        return VertexiumBlueprintsEdge.create(this, this.getGraph().getEdge(VertexiumBlueprintsConvert.idToString(id), authorizations), authorizations);
    }

    public void removeEdge(com.tinkerpop.blueprints.Edge edge) {
        Edge sgEdge = VertexiumBlueprintsConvert.toVertexium(edge);
        this.getGraph().deleteEdge(sgEdge, this.getAuthorizationsProvider().getAuthorizations());
    }

    public Iterable<com.tinkerpop.blueprints.Edge> getEdges() {
        final Authorizations authorizations = this.getAuthorizationsProvider().getAuthorizations();
        return new ConvertingIterable<Edge, com.tinkerpop.blueprints.Edge>(this.getGraph().getEdges(authorizations)){

            protected com.tinkerpop.blueprints.Edge convert(Edge edge) {
                return VertexiumBlueprintsEdge.create(VertexiumBlueprintsGraph.this, edge, authorizations);
            }
        };
    }

    public Iterable<com.tinkerpop.blueprints.Edge> getEdges(String key, Object value) {
        final Authorizations authorizations = this.getAuthorizationsProvider().getAuthorizations();
        return new ConvertingIterable<Edge, com.tinkerpop.blueprints.Edge>(this.getGraph().query(authorizations).has(key, (Predicate)Compare.EQUAL, value).edges()){

            protected com.tinkerpop.blueprints.Edge convert(Edge edge) {
                return VertexiumBlueprintsEdge.create(VertexiumBlueprintsGraph.this, edge, authorizations);
            }
        };
    }

    public GraphQuery query() {
        Authorizations authorizations = this.getAuthorizationsProvider().getAuthorizations();
        return new VertexiumBlueprintsGraphQuery(this, authorizations);
    }

    public void shutdown() {
        this.getGraph().shutdown();
    }

    public String toString() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    public Graph getGraph() {
        return this.vertexiumGraph;
    }

    public VisibilityProvider getVisibilityProvider() {
        return this.visibilityProvider;
    }

    public AuthorizationsProvider getAuthorizationsProvider() {
        return this.authorizationsProvider;
    }
}

