/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.vertexium.GraphFactory;
import org.vertexium.cli.CliVertexiumCypherQueryContext;
import org.vertexium.cli.ParametersBase;
import org.vertexium.cypher.VertexiumCypherQuery;
import org.vertexium.cypher.VertexiumCypherQueryContext;
import org.vertexium.cypher.VertexiumCypherResult;
import org.vertexium.cypher.ast.CypherCompilerContext;
import org.vertexium.util.ConfigurationUtils;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class ExecuteCypherQuery {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(ExecuteCypherQuery.class);

    public static void main(String[] args) throws Exception {
        int result = new ExecuteCypherQuery().run(args);
        System.exit(result);
    }

    private int run(String[] args) throws Exception {
        Parameters params = new Parameters();
        JCommander j = new JCommander((Object)params, args);
        if (params.help) {
            j.usage();
            return -1;
        }
        Map config = ConfigurationUtils.loadConfig(params.getConfigFileNames(), (String)params.configPropertyPrefix);
        Graph graph = new GraphFactory().createGraph(config);
        Authorizations authorizations = params.getAuthorizations(graph);
        CliVertexiumCypherQueryContext ctx = new CliVertexiumCypherQueryContext(graph, authorizations);
        CliVertexiumCypherQueryContext.setLabelPropertyName(params.cypherLabelProperty);
        CypherCompilerContext compilerContext = new CypherCompilerContext(ctx.getFunctions());
        long startTime = System.currentTimeMillis();
        String queryString = params.query.stream().collect(Collectors.joining(" "));
        VertexiumCypherQuery query = VertexiumCypherQuery.parse((CypherCompilerContext)compilerContext, (String)queryString);
        VertexiumCypherResult results = query.execute((VertexiumCypherQueryContext)ctx);
        results.stream().forEach(row -> results.getColumnNames().forEach(column -> System.out.println(row.getByName(column))));
        long endTime = System.currentTimeMillis();
        LOGGER.info("total time: %.2fs", new Object[]{(double)(endTime - startTime) / 1000.0});
        return 0;
    }

    private static class Parameters
    extends ParametersBase {
        @Parameter(description="Cypher query to run", required=true)
        private List<String> query;

        private Parameters() {
        }
    }
}

